<?php

require_once XOOPS_ROOT_PATH.'/header.php';
require_once(dirname(dirname(__FILE__)) . '/constants.php');
require_once(dirname(dirname(__FILE__)) . '/include/groupperm_function.php');
require_once(dirname(dirname(__FILE__)) . '/include/misc.php');
require_once(dirname(dirname(__FILE__)) . '/include/db.php');

$gperm_ext_upload = spicky_checkright($mydirname, SPICKY_GPERM_EXT_UPLOAD);
$gperm_ext_upload_super = spicky_checkright($mydirname, SPICKY_GPERM_EXT_UPLOAD_SUPER);
if ($gperm_ext_upload == 0 && $gperm_ext_upload_super == 0) {
    exit();
}

if (is_object($xoopsUser)) {
	$user_id = $xoopsUser->getVar('uid');
} else {
	$user_id = 0;
}

$width = 320;
$height= 320;

$type_dummy = 2;
$ext_dummy = 'jpg';

$code = spicky_get_randam_code();
$tmp_image_id = spicky_insert_image_tmp('',  $code, $width, $height, $type_dummy, $user_id, SPICKY_UPLOAD_TYPE_EXT, $_SERVER['REMOTE_ADDR']);

$dest_dir = spicky_mkdir_p_number($tmp_image_id, 1);
$dest_file = $dest_dir . '/' . $tmp_image_id . '_' . $code . '.' . $ext_dummy;

copy($_FILES['upfile']['tmp_name'], $dest_file);

$type = spicky_is_image_file($dest_file);

if ($type == 0) {
	// no image file
	exit();
}

if ($type != $type_dummy) {
	$new_file = $dest_dir . '/' . $tmp_image_id . '_' . $code . '.' . $GLOBALS['spicky_image_ext'][$type];
	//rename($dest_file, $new_file);
	copy($dest_file, $new_file);
	//unlink($dest_file);
	spicky_update_image_tmp($tmp_image_id, $type);
}

$size = getimagesize($dest_file);
$width = $size[0];
$height = $size[1];

if ($gperm_ext_upload_super) {
	$status = SPICKY_STATUS_OK;
} else {
	$status = SPICKY_STATUS_NO_AUTH;
}

spicky_upload_image_resize_regular($type, $dest_file);
$image_id = spicky_insert_image('', '', $code, $width, $height, $type, $user_id, $_GET['paint_from_id'], $status, SPICKY_UPLOAD_TYPE_EXT, $_SERVER['REMOTE_ADDR']);
spicky_move_tmp_to_image($tmp_image_id, $image_id, $code, $type);
spicky_update_image_tmp_master_id($tmp_image_id, $image_id);

$image['id'] = $image_id;
$image['code'] = $code;
$image['type'] = $type;

$filename = XOOPS_ROOT_PATH . spicky_make_image_path($mydirname, $image, 0);

$exif_str = '';
$model = '';
if (function_exists('exif_read_data') && $image['type'] == SPICKY_JPG_FILE) {
	$exif = exif_read_data($filename, 0, true);
	if ($exif) {
		foreach ($exif as $key => $section) {
			foreach ($section as $name => $val) {
				if ($key == 'IFD0' && $name == 'Model') {
					$model = $val;
				}
				$exif_str .= "$key.$name: $val\n";
			}
		}
	}
}

$title = mb_convert_encoding($_POST['title'], _CHARSET, 'auto');
$desc = mb_convert_encoding($_POST['desc'], _CHARSET, 'auto');
$tag = mb_convert_encoding($_POST['tag'], _CHARSET, 'auto');

if (0 < @$_POST['time_limit']) {
  $time_limit = intval(@$_POST['time_limit']) * 60 + time();
} else {
  $time_limit = 0;
}

spicky_update_image($image_id, $title, $desc, 
		    1, 1, 1, $user_id, '', $status, $exif_str, $model, $time_limit );

if (strstr($tag, '|')) {
  $tag_list = split('\|', $tag);
} else {
  $tag_list = split(' ', $tag);
}

foreach ($tag_list as $tag_name) {
  if ($tag_name != '') {
    $tag_id = spicky_add_tag_to_image($image_id, $tag_name, $user_id, 1);
    spicky_countup_tag($tag_name, 1);
  }
}

if ($xoopsModuleConfig['auto_model_tag'] && $model != '' && count($tag_list) < $xoopsModuleConfig['num_of_tag']) {
	$tag_name = trim($model);
	$tag_id = spicky_add_tag_to_image($image_id, $tag_name, $user_id, 1);
	spicky_countup_tag($tag_name, 1);
}

spicky_image_tag_set($image_id);