<?php

require_once XOOPS_ROOT_PATH.'/header.php';
require_once(dirname(dirname(__FILE__)) . '/constants.php');
require_once(dirname(dirname(__FILE__)) . '/include/groupperm_function.php');
require_once(dirname(dirname(__FILE__)) . '/include/misc.php');
require_once(dirname(dirname(__FILE__)) . '/include/db.php');

$constpref = strtoupper( $mydirname ) ;

$gperm_image_upload = spicky_checkright($mydirname, SPICKY_GPERM_IMAGE_UPLOAD);
$gperm_image_upload_super = spicky_checkright($mydirname, SPICKY_GPERM_IMAGE_UPLOAD_SUPER);
if ($gperm_image_upload == 0 && $gperm_image_upload_super == 0) {
    if (SPICKY_DIRCUT_URL) {
        redirect_header(XOOPS_URL . '/', 2, _MD_SPICKY_NO_RIGHT_UPLOAD);
    } else if (SPICKY_SHORT_URL) {
        redirect_header(XOOPS_URL . '/modules/' . $mydirname . '/', 2, _MD_SPICKY_NO_RIGHT_UPLOAD);
    } else {
        redirect_header('index.php', 2, _MD_SPICKY_NO_RIGHT_UPLOAD);
    }
    exit();
}

if (is_object($xoopsUser)) {
	$user_id = $xoopsUser->getVar('uid');
} else {
	$user_id = 0;
}

spicky_main_css($mydirname);
spicky_set_gperm($mydirname);

$xoopsTpl->assign('mydirname', $mydirname);

$upload_error = array(
'UPLOAD_ERR_OK',
'UPLOAD_ERR_INI_SIZE',
'UPLOAD_ERR_FORM_SIZE',
'UPLOAD_ERR_PARTIAL',
'UPLOAD_ERR_NO_FILE',
'UPLOAD_ERR_NO_TMP_DIR',
'UPLOAD_ERR_CANT_WRITE',
'UPLOAD_ERR_EXTENSION',
);

if (@$_POST['stat'] == 2) {

	$image_list = array();
	$num_list = array();
	
	$error_message = array();
	$flgOk = false;
	
	for ($i = 1; $i <= 100; $i++) {
		$error = @$_FILES['upfile' . $i]['error'];
		
		if ($error != 0 && $error != 4) {
			$error_message[] = _MD_SPICKY_FAILED_UPLOAD . ' ' . _MD_SPICKY_IMAGE . $i . ':' . $upload_error[$error];
		}
	
		if (isset($_FILES['upfile' . $i]) == false) {
			continue;
		}
		
		if (@is_readable($_FILES['upfile' . $i]['tmp_name']) == false) {
			continue;
		}
		
		$flgOk = true;
		
		$num_list[] = $i;

		$src_image = $_FILES['upfile' . $i]['tmp_name'];
		$type = spicky_is_image_file($src_image);
		
		if ($type == 0) {
			$error_message[] = _MD_SPICKY_FAILED_UPLOAD . ' ' . _MD_SPICKY_IMAGE . $i . ':' . _MD_SPICKY_NO_IMAGE_FILE;
			continue;
		}
		
		if (($xoopsModuleConfig['max_image_size'] * 1024 * 1240) < $_FILES['upfile' . $i]['size']) {
			$error_message[] = _MD_SPICKY_FAILED_UPLOAD . ' ' . _MD_SPICKY_IMAGE . $i . ':' .
				_MD_SPICKY_IMAGE_SIZE_OVER;
			continue;
		}
		
		if (@$xoopsModuleConfig['max_dot_limit']) {
			$check = spicky_check_image_width_height($src_image,
				$xoopsModuleConfig['max_width'],
				$xoopsModuleConfig['max_height']);
		
			if ($check == false) {
				$error_message[] = _MD_SPICKY_FAILED_UPLOAD . ' ' . _MD_SPICKY_IMAGE . $i . ':' .
					_MD_SPICKY_IMAGE_WHSIZE_OVER . ':(' . $xoopsModuleConfig['max_width'] . 'x' . $xoopsModuleConfig['max_height'] . ')';
				continue;
			}
		}
	
		$size = getimagesize($src_image);
		$width = $size[0];
		$height = $size[1];
	
		$ext = $spicky_image_ext[$type];

		$code = spicky_get_randam_code();
		$image_id = spicky_insert_image_tmp('', $code, $width, $height, $type, $user_id, SPICKY_UPLOAD_TYPE_NORMAL, $_SERVER['REMOTE_ADDR']);
	
		$dest_dir = spicky_mkdir_p_number($image_id, 1);
		$dest_file = $dest_dir . '/' . $image_id . '_' . $code . '.' . $ext;
		
		move_uploaded_file($src_image, $dest_file);
		spicky_upload_image_resize_regular($type, $dest_file);

		$image[$i] = array('id' => $image_id, 'width' => $width, 'height' => $height,
					'code' => $code, 'size' => 120, 'type' => $type, 'ext' => $ext);
	}
	
	if ($flgOk == false) {
		$error_message[] = _MD_SPICKY_SET_IMAGE_FILE;
	}
	
	if (count($error_message)) {
		$xoopsTpl->assign('error_message', $error_message);
		$xoopsTpl->assign('upload_max_filesize', ini_get('upload_max_filesize'));
		$xoopsTpl->assign('max_upload_size_real', $xoopsModuleConfig['max_upload_size'] * 1024 * 1024);
		$xoopsTpl->assign('max_upload_size', $xoopsModuleConfig['max_upload_size']);
		$xoopsTpl->assign('module_config', $xoopsModuleConfig);
		$xoopsOption['template_main'] = $mydirname.'_upload.html';
		require_once XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}

	$tool_list = spicky_get_tool_list();
	
	$bookmark_list = spicky_get_bookmarklist_list($user_id);

	if (count(@$bookmark_list) == 0) {
		$bookmark_list_id = spicky_add_bookmarklist(_MD_SPICKY_BOOKMARK_DFT_NAME, '', $user_id);
		$bookmark_list = spicky_get_bookmarklist_list($user_id);
	}
	$xoopsTpl->assign('bookmark_list', $bookmark_list);

	$xoopsTpl->assign('num_list', $num_list);
	
	$xoopsTpl->assign('image', $image);
	$xoopsTpl->assign('module_config', $xoopsModuleConfig);
	$xoopsTpl->assign('tool_list', $tool_list);
	$xoopsTpl->assign('mydirname', $mydirname);
	$xoopsTpl->assign('mytrustdirname', $mytrustdirname);
	$xoopsTpl->assign(array('image_id' => $image_id, 'code' => $code, 'ext' => $spicky_image_ext[$type]));
	$xoopsOption['template_main'] = $mydirname.'_upload2.html';
} else if (@$_POST['stat'] == 3) {

	$gperm_image_upload_super = spicky_checkright($mydirname, SPICKY_GPERM_IMAGE_UPLOAD_SUPER);

	if ($gperm_image_upload_super) {
		$status = SPICKY_STATUS_OK;
	} else {
		$status = SPICKY_STATUS_NO_AUTH;
	}
		
	for ($i = 1; $i <= 100; $i++) {
		if (isset($_POST['image_id' . $i]) == false) {
			continue;
		}
	
		$tool_check = array();
		for ($j=1; $j < 1000; $j++) {
			if (@$_POST['batch']) {
				if (isset($_POST['tool1' . '_' . $j])) {
					$tool_check[] = $j;
				}
			} else {
				if (isset($_POST['tool' . $i . '_' . $j])) {
					$tool_check[] = $j;
				}
			}
		}

		if (@$_POST['batch']) {
			$tag_list = split(' ', $_POST['tag1']);
			$tag = $_POST['tag1'];
		} else {
			$tag_list = split(' ', $_POST['tag' . $i]);
			$tag = $_POST['tag' . $i];
		}

		if (strstr($tag, '|')) {
			$tag_list = split('\|', $tag);
		} else {
			$tag_list = split(' ', $tag);
		}
		
		$image = spicky_get_image_tmp($_POST['image_id' . $i]);
		
		$image_id = spicky_insert_image($image['title'], '', $image['code'], $image['width'], $image['height'], $image['type'], $user_id, '', '', SPICKY_UPLOAD_TYPE_NORMAL, $_SERVER['REMOTE_ADDR']);
	
		$image['id'] = $image_id;
	
		$time_limit = 0;
		if (@$_POST['batch']) {
			$title = $_POST['title1'];
			$desc = $_POST['desc1'];
			$public_level = $_POST['public_level1'];
			$pasteok = @$_POST['pasteok1'];
			$limit_level = @$_POST['limit_level1'];
			$delete_password = @$_POST['delete_password1'];
			if (@$_POST['time_limit1']) {
				$time_limit = @$_POST['time_limit1'] * 60 + time();
			}
		} else {
			$title = $_POST['title' . $i];
			$desc = $_POST['desc' . $i];
			$public_level = $_POST['public_level' . $i];
			$pasteok = @$_POST['pasteok' . $i];
			$limit_level = @$_POST['limit_level' . $i];
			$delete_password = @$_POST['delete_password' . $i];
			if (@$_POST['time_limit1']) {
				$time_limit = @$_POST['time_limit' . $i] * 60 + time();
			}
		}

		foreach ($tag_list as $tag_name) {
			if ($tag_name != '') {
				$tag_id = spicky_add_tag_to_image($image_id, $tag_name, $user_id, $limit_level);
				spicky_countup_tag($tag_name, 1);
			}
		}
	
		spicky_insert_tool_image_link($image_id, $tool_check);
		
		spicky_move_tmp_to_image($_POST['image_id' . $i], $image_id, $image['code'], $image['type']);
		
		spicky_update_image_tmp_master_id($_POST['image_id' . $i], $image_id);
		
		$filename = XOOPS_ROOT_PATH . spicky_make_image_path($mydirname, $image, 0);

		$exif_str = '';
		$model = '';
		if (function_exists('exif_read_data') && $image['type'] == SPICKY_JPG_FILE) {
			$exif = exif_read_data($filename, 0, true);
			if ($exif) {
				foreach ($exif as $key => $section) {
					foreach ($section as $name => $val) {
						if ($key == 'IFD0' && $name == 'Model') {
							$model = $val;
						}
						$exif_str .= "$key.$name: $val\n";
					}
				}
			}
		}
		
		if ($xoopsModuleConfig['auto_model_tag'] && $model != '' && count($tag_list) < $xoopsModuleConfig['num_of_tag']) {
			$tag_name = trim($model);
			$tag_id = spicky_add_tag_to_image($image_id, $tag_name, $user_id, $limit_level);
			spicky_countup_tag($tag_name, 1);
		}
		
		//echo "exif_str:$exif_str "; exit();	
		if ($delete_password != '') {
			$delete_password = md5($delete_password);
		}
		
		spicky_update_image($image_id, $title, $desc, 
				$public_level, @$pasteok, @$limit_level, $user_id, $delete_password, $status, $exif_str, $model, $time_limit);
		
		spicky_image_tag_set($image_id);
		
		if (@$_POST['batch']) {
			if (@$_POST['bookmark_check1'] == 2) {
				spicky_add_bookmark($image_id, $_POST['bookmark_list_id1'], $user_id);
			}
		} else {
			if ($_POST['bookmark_check'. $i] == 2) {
				spicky_add_bookmark($image_id, $_POST['bookmark_list_id' . $i], $user_id);
			}
		}
		$tags['POST_URL'] = XOOPS_URL . '/modules/' . $mydirname . '/index.php?page=image&id=' . intval($image_id);
		
		$notification_handler =& xoops_gethandler('notification');
		$notification_handler->triggerEvent('global', 0, 'image_submit', $tags);

	}


	if ($status == SPICKY_STATUS_OK) {
		redirect_header('index.php', 2, _MD_SPICKY_ENTRYED_IMAGE);
	} else {
		redirect_header('index.php', 2, _MD_SPICKY_WAIT_ADMISSION);
	}
	
	
	exit();
} else {
	$xoopsTpl->assign('upload_max_filesize', ini_get('upload_max_filesize'));
	$xoopsTpl->assign('max_upload_size_real', $xoopsModuleConfig['max_upload_size'] * 1024 * 1024);
	$xoopsTpl->assign('max_upload_size', $xoopsModuleConfig['max_upload_size']);
	$xoopsTpl->assign('module_config', $xoopsModuleConfig);
	$xoopsOption['template_main'] = $mydirname.'_upload.html';
}

require_once XOOPS_ROOT_PATH.'/footer.php';

