//
//  XspfMCollectionViewController.m
//  XspfManager
//
//  Created by Hori,Masaki on 09/11/05.
//  Copyright 2009 masakih. All rights reserved.
//

#import "XspfMCollectionViewController.h"

#import "XspfMCollectionView.h"
#import "XspfMCollectionViewItem.h"
#import "XspfMXspfObject.h"

@interface NSCollectionView(CocoaPrivatemethods)
- (void)_getRow:(NSUInteger *)fp8 column:(NSUInteger *)fp12 forPoint:(NSPoint)fp16;
- (NSRect)_frameRectForIndexInGrid:(NSUInteger)fp8 gridSize:(NSSize)fp12;
- (NSRange)columnCountRange;
@end


@interface XspfMCollectionViewController (XspfMPrivate)
- (void)setCollectionItem:(XspfMCollectionViewItem *)newItem;
@end

static NSString *const XspfMCollectionItemSizeKey = @"Collection Item Size";

@implementation XspfMCollectionViewController

- (id)init
{
	[super initWithNibName:@"CollectionView" bundle:nil];
	
	return self;
}

- (void)awakeFromNib
{
	NSInteger type = [[NSUserDefaults standardUserDefaults] integerForKey:XspfMCollectionItemSizeKey];
	[self setCollectionItem:type == 0 ? regularItem : smallItem];
}

- (void)setCollectionItem:(XspfMCollectionViewItem *)newItem
{
	if(collectionViewItem == newItem) return;
	
	[collectionView setItemPrototype:newItem];
	NSSize viewSize = [[newItem view] frame].size;
	[collectionView setMinItemSize:viewSize];
	[collectionView setMaxItemSize:viewSize];
	[scrollView setVerticalLineScroll:viewSize.height];
	collectionViewItem = newItem;
	
	
	[[NSUserDefaults standardUserDefaults] setInteger:collectionViewItem == regularItem ? 0 : 1 forKey:XspfMCollectionItemSizeKey];
}

- (IBAction)changeLabel:(id)sender
{
	XspfMXspfObject *object = [sender representedObject];
	object.label = [sender objectValue];
}

- (IBAction)collectionViewItemViewRegular:(id)sender
{
	[self setCollectionItem:regularItem];
}
- (IBAction)collectionViewItemViewSmall:(id)sender
{
	[self setCollectionItem:smallItem];
}

- (XspfMCollectionItemType)collectionItemType
{
	if(collectionViewItem == regularItem) return typeXspfMRegularItem;
	if(collectionViewItem == smallItem) return typeXSpfMSmallItem;
	
	return typeXspfMUnknownItem;
}

#pragma mark#### XspfMCollectionView Delegate ####
- (void)enterAction:(XspfMCollectionView *)view
{
	[NSApp sendAction:@selector(openXspf:) to:nil from:self];
}

// QLPreviewPanel support
- (NSRect)selectionItemRectForLeopard
{
	NSRect collectionFrame = [collectionView frame];
	NSSize itemSize = [collectionView minItemSize];
	
	// get right edge item colum.
	NSPoint rightEdge = NSMakePoint(collectionFrame.size.width - 1, itemSize.height / 2);
	NSUInteger col = 0;
	NSUInteger row = 0;
	[collectionView _getRow:&row column:&col forPoint:rightEdge];
	
	// get selected item's row and column.
	NSUInteger index = [[self representedObject] selectionIndex];
	NSUInteger maxCol = col;
	col = index % maxCol;
	row = index / maxCol;
	
	// caluculate selected item view's image view point.
	NSPoint itemImagePoint;
	itemImagePoint.x = itemSize.width / 2 + itemSize.width * col;
	itemImagePoint.y = itemSize.height * .2 + itemSize.height * row;	// CollectionView is fliped.
	
	// get item image view.
	NSView *thumbnail = [collectionView hitTest:itemImagePoint];
	NSView *view = [[thumbnail superview] superview];
	
	NSRect frame = [thumbnail frame];
	
	NSRect convertedRect = [view convertRect:frame toView:collectionView];
	if(!NSIntersectsRect([collectionView visibleRect], convertedRect)) {
		return NSZeroRect;
	}
	
	frame = [view convertRectToBase:frame];
	frame.origin = [[view window] convertBaseToScreen:frame.origin];
	return frame;
}
- (NSRect)selectionItemRect
{
	if(![collectionView respondsToSelector:@selector(itemAtIndex:)]) {
		return [self selectionItemRectForLeopard];
	}
	id item = [collectionView itemAtIndex:[[self representedObject] selectionIndex]];
	NSRect rect = [item thumbnailFrameCoordinateBase];
	return rect;
}

#pragma mark#### Test ####
- (void)test01:(id)sender
{
	HMLog(HMLogLevelError, @"hoge");
}
	

@end
