// -*-C++-*-
#ifndef _array_h_
# define _array_h_

# define MAX_VECTOR_LENGTH (INT_MAX / sizeof (lisp))
# define ARRAY_RANK_LIMIT (SHRT_MAX + 1)

/* z̊NX
   ȂŔz̊NXȂ̂ɖOxN^Ȃ̂Ƃ
   ׂƂ͋CɂȂ悤ɁBarray̎Asubscripts
   ߂arrayȂŁAԂ̓xN^̃ANZXȂ̂ŁA
   ł̂B*/
class lbase_vector: public lisp_object
{
public:
  int length;          // contentsɊ܂܂vf̌
  void *contents;      // vf̔z

  ~lbase_vector ()
    {
      xfree (contents);
    }

  void common_init ()
    {
      contents = 0;
    }
};

/* zƔPxN^̊NX */
class lbase_array: public lbase_vector
{
public:
  int *dims;               // ̔z
  lisp displaced_to;       // LObjectBLĂȂȂnil
  lisp referenced_list;    // LĂObject̃Xg
  short rank;              // rank
  char adjustable;         // TCYύX\?
  char has_fillp;          // tB|C^Ă?

  ~lbase_array ();
  void common_init ();
};

/* PxN^̊NX */
class lbase_complex_vector: public lbase_array
{
public:
  /* BŒTCYallocatêijȂ̂łɎĂ */
  int dimension;

  void common_init ()
    {
      lbase_array::common_init ();
      dims = &dimension;
      rank = 1;
    }
  ~lbase_complex_vector ()
    {
      dims = 0;
    }
};

/* ʔzƕz͍ƂĂ͂܂łB
  ANZX֐ƍHv(Ƃ)҂ʂĂB
  킴킴ʃNXɂ̂͒PɎ̓sł(Memory allocation
  lΕ)B*/

/* ʔz */
class lgeneral_array: public lbase_array
{
};

/* z */
class lstring_array: public lbase_array
{
};

/* ^Cv`FbÑ}N
   ӂ͖OႮႵĂĔɕɂ */

# define base_array_p(X) \
  object_type_mask_p ((X), TAarray | TAsimple, TAarray)

# define base_vector_p(X) object_type_bit_p ((X), TAarray)

# define common_vector_p(X) object_type_bit_p ((X), TAvector)

# define base_simple_vector_p(X) \
  object_type_mask_p ((X), TAvector | TAsimple, TAvector | TAsimple)

# define base_complex_vector_p(X) \
  object_type_mask_p ((X), TAvector | TAsimple, TAvector)

# define general_array_p(X) typep ((X), Tarray)
# define string_array_p(X) typep ((X), Tstring_array)

# define common_array_p(X) object_type_bit_p ((X), TAarray)

/* xN^̗vfBtB|C^ꍇ̓tB|C^̒l */
inline int &
xvector_length (lisp x)
{
  assert (base_vector_p (x));
  return ((lbase_vector *)x)->length;
}

/* xN^̗vf̔z */
inline void *&
xbase_vector_contents (lisp x)
{
  assert (base_vector_p (x));
  return ((lbase_vector *)x)->contents;
}

/* xN^̎BȂ킿AxN^̎ۂ̒B*/
inline int &
xvector_dimension (lisp x)
{
  assert (base_complex_vector_p (x));
  return ((lbase_complex_vector *)x)->dimension;
}

/* zŜ̗vf */
inline int &
xarray_total_size (lisp x)
{
  assert (base_array_p (x));
  return ((lbase_array *)x)->length;
}

/* z̎̔z */
inline int *&
xarray_dims (lisp x)
{
  assert (base_array_p (x));
  return ((lbase_array *)x)->dims;
}

/* z̋LObjectBLĂȂȂnil */
inline lisp &
xarray_displaced_to (lisp x)
{
  assert (base_array_p (x));
  return ((lbase_array *)x)->displaced_to;
}

/* xLĂObject̃Xg */
inline lisp &
xarray_referenced_list (lisp x)
{
  assert (base_array_p (x));
  return ((lbase_array *)x)->referenced_list;
}

/* zrank */
inline short &
xarray_rank (lisp x)
{
  assert (base_array_p (x));
  return ((lbase_array *)x)->rank;
}

/* z񂪃TCYύX\? */
inline char &
xarray_adjustable (lisp x)
{
  assert (base_array_p (x));
  return ((lbase_array *)x)->adjustable;
}

/* z񂪃tB|C^Ă? */
inline char &
xarray_has_fillp (lisp x)
{
  assert (base_array_p (x));
  return ((lbase_complex_vector *)x)->has_fillp;
}

/* ʔz̗vf̔z */
inline lisp *&
xgeneral_array_contents (lisp x)
{
  assert (general_array_p (x));
  return (lisp *&)xbase_vector_contents (x);
}

/* z̗vf̔z */
inline Char *&
xstring_array_contents (lisp x)
{
  assert (string_array_p (x));
  return (Char *&)xbase_vector_contents (x);
}

inline void
check_array (lisp x)
{
  if (!common_array_p (x))
    FEtype_error (x, Qarray);
}

inline lgeneral_array *
make_general_array ()
{
  lgeneral_array *p = ldata <lgeneral_array, Tarray>::lalloc ();
  p->common_init ();
  return p;
}

inline lstring_array *
make_string_array ()
{
  lstring_array *p = ldata <lstring_array, Tstring_array>::lalloc ();
  p->common_init ();
  return p;
}

void check_array_type (lisp);
Char initial_char_elem (lisp);
lisp array_element_type (lisp);
void check_displace_type (lisp, lisp);
lisp displace_array (lisp, int, lisp, lisp, lisp);
void adjust_displace_array (lisp, void *);

#endif
