class AuthController < ApplicationController

public
	def status404
		render(nothing:true, status:404)
	end

	def show
		flash_msg = ""

		# 下請けコマンドが存在するか確認
		[
			[CONVERT_CMD, "-version"],
			[JPEGTRAN_CMD, "-help"],
#			[UNZIP_CMD],
#			[GHOSTSCRIPT_CMD, "--version"],
		].each do |cmd|
			if system(*cmd, out:File::NULL, err:File::NULL).nil?
				flash_msg += " #{cmd[0]} が実行できません"
			end
		end

		if flash_msg.present?
			flash[:notice] = flash[:notice].to_s + flash_msg
		end
	end

	def challenge
		session[:user_id] = nil
		username = params[:auth][:username]
		password = params[:auth][:password]

		user = User.auth_challenge(username, password)
		if user
			user_id = user.id
			user_name = user.name
			vpath = user.last_path			# 前回の場所へ
			location = user.last_location

			remote_host = request.remote_host
			remote_addr = request.remote_addr
			user_agent = request.user_agent

			ua_type = []
			# ハードウェア
			ua_type.push(:pc, :win)		if user_agent =~ /\(Windows NT\b/
			ua_type.push(:pc, :mac)		if user_agent =~ /\(Macintosh;/
			ua_type << :iphone			if user_agent =~ /\(iPhone;/
			ua_type << :ipodtouch		if user_agent =~ /\(iPod touch;/
			ua_type << :ipad			if user_agent =~ /\(iPad;/
			ua_type << :kindle			if user_agent =~ /\bKindle\b/

			# OS
			ua_type << :ios				if user_agent =~ /\blike Mac OS X\b/
			ua_type << :android			if user_agent =~ /\bAndroid\b/
			ua_type << :linux			if user_agent =~ /\(Linux;/
			ua_type << :windowsphone	if user_agent =~ /\bWindows Phone\b/

			# ブラウザ, ソフトウェア
			ua_type << :chrome			if user_agent =~ /\bChrome\b/
			ua_type << :firefox			if user_agent =~ /\bFirefox\b/
			ua_type << :safari			if user_agent =~ /\bSafari\b/
			ua_type << :opera			if user_agent =~ /\bOpera\b/
			ua_type << :comicglass		if user_agent =~ /^comicglass\//

			ua_type.delete(:linux)		if ua_type.include?(:android)
			ua_type.delete(:safari)		if ua_type.include?(:chrome)

			ua_type = ua_type.sort.uniq

			User.transaction do
				user.secret = nil
				user.auth_at = Time.now
				user.access_from = "[%s][%s]%s" % [remote_host, remote_addr, user_agent]
				user.save!

				Log.add(user_id, "User login: #{user_id}:#{user_name}")
				Log.add(user_id, "HTTP_USER_AGENT: #{user_agent}")
				Log.add(user_id, "REMOTE_HOST: #{remote_host}")
				Log.add(user_id, "REMOTE_ADDR: #{remote_addr}")
			end

			session[:user_id] = user_id
			session[:user_name] = user_name
			session[:ua_type] = ua_type
			session[:last_path] = vpath
			session[:last_path_from] = nil
			session[:last_location] = location
			Cache.do_expire(user_id)

			return redirect_to(last_path)
		end

		# 認証失敗したらやり直す
		flash[:username] = username
		flash[:password] = password
		redirect_to(:back, notice:"認証に失敗しました")
	end

	def logout
		user_id = session[:user_id]
		user_name = session[:user_name]
		if user_id
			Log.add(user_id, "User logout: #{user_id}:#{user_name}")
			# 副作用としてキャッシュのクリアも行う
			Cache.do_clear(user_id)
		end

		reset_session
		redirect_to(auth_path)
	end

	def copyright
		# NOP
	end

	def history
		history = []
		content = []

		File.open(File.absolute_path("HISTORY.txt", Rails.root), "rt:UTF-8") do |h|
			h.each_line do |a_line|
				a_line.strip!
				case a_line
				 when /^--(.*)$/
					s = $1.strip
					content = []
					history << {title:s, content:content}
				 when /^・(.*)$/
					s = $1.strip
					content << s
				 when /^[\s　]*(.+)[\s　]*$/
					s = $1.strip
					content[0] = ""  if content.empty?
					content[-1] += " " + s
				end
			end
		end

		@history = history
	end
end
