class FilelistController < ApplicationController

 private
	# vpathで示される本の情報を得る
	# 未読ならpageは0
	def get_book_info(vpath)
		pagelist = Book(vpath).pagelist
		pages = pagelist.count
		page = 0
		location = ""
		start_at = nil
		end_at = nil

		if pages > 0
			reading = Reading.yomeya_find(vpath)
			if reading
				if reading.location.present?
					location = reading.location
					page = Book(vpath).index(location) + 1
				end
				start_at = reading.start_at
				end_at = reading.end_at
			end
		end

		return {
			pages: pages,
			page: page,
			location: location,
			start_at: start_at,
			end_at: end_at,
		}
	end

	# yyyy/mm/dd 〜 yyyy/mm/dd の形式の文字列を得る
	def span_str(st, ed)	# start, endだとendが予約語でNG
		st = st.localtime  if st.present?
		ed = ed.localtime  if ed.present?

		if !st.present?			# 未読の場合
			r = ""
		elsif !ed.present?		# 読んでいる途中の場合
			r = st.strftime("%Y/%m/%d") + "〜"
		else					# 読了の場合
			if st.year == ed.year
				if st.month == ed.month
					if st.day == ed.day
						r = st.strftime("%Y/%m/%d")
					else
						r = st.strftime("%Y/%m/%d") + "〜" + ed.strftime("%d")
					end
				else
					r = st.strftime("%Y/%m/%d") + "〜" + ed.strftime("%m/%d")
				end
			else
				r = st.strftime("%Y/%m/%d") + "〜" + ed.strftime("%Y/%m/%d")
			end
		end

		return r
	end

	# filelistの表示用のリストを作成する
	def get_filelist(vpath)
		Cache.transaction do
			filelist = Directory(vpath).list

			filelist.each do |f|	# filelist自身を加工
				title = ""
				desc = ""
				indicator1 = []
				indicator2 = []
				sortkey = ""

				case f[:type]
				 when :junction
					case f[:vpath].v
					 when "*read"
						title = "読みかけの本"
						desc = "Reading"
						sortkey = "A0"
					 when "*bookmark"
						title = "ブックマーク"
						desc = "Bookmarking"
						sortkey = "A1"
					 when "*tag"
						title = "タグ"
						desc = "Tagging"
						sortkey = "A2"
					end
				 when :images
					p = f[:vpath].parent
					if p.v == vpath.v
						title = "このディレクトリ"
						sortkey = "C"
					else
						title = p.basename
						sortkey = "D" + title
					end
				 when :pdf, :zip
					title = f[:vpath].basename(".*")
					sortkey = "D" + title
				 else
					title = f[:vpath].basename
					sortkey = "D" + title
				end

				if f[:type].is_any_of(:dir, :dir_missing)
					desc = "Directory"
					indicator1 << :dir
					# sortkey = "B" + title
				end

				if f[:type].is_any_of(:images, :pdf, :zip)
					bookinfo = get_book_info(f[:vpath])
					if bookinfo[:start_at].blank?		# 未読の場合
						indicator1 << :unread
					elsif bookinfo[:end_at].blank?		# 読んでいる途中の場合
						indicator1 << :reading
					else				# 読了の場合
						indicator1 << :read
					end

					if indicator1.include?(:unread) ||
							(indicator1.include?(:read) && bookinfo[:page] == bookinfo[:pages])
						desc = ("%dp" % bookinfo[:pages]) +
								" " + span_str(bookinfo[:start_at], bookinfo[:end_at])
					else
						desc = ("%d/%dp" % [bookinfo[:page], bookinfo[:pages]]) +
								" " + span_str(bookinfo[:start_at], bookinfo[:end_at])
					end
				end

				if f[:type].is_any_of(:text, :html)
					desc = File.size(f[:vpath].r).to_s(:human_size)
				end

				indicator2 << :pdf  if f[:type] == :pdf
				indicator2 << :zip  if f[:type] == :zip

				f[:title] = title
				f[:desc] = desc
				f[:indicator1] = indicator1
				f[:indicator2] = indicator2
				f[:sortkey] = sortkey
			end
			filelist.sort_by! { |v| key4sort(v[:sortkey].to_s) }

			return filelist
		end
	end

 public
	def show
		vpath = Vpath(session[:user_id], params[:path] || "")

		# パラメータの検査
		if !valid_directory_path?(vpath)
			return redirect_to(filelist_path)
		end
		@vpath = vpath

		# @locationのセット
		location = Cache.fetch_location(vpath)
		location = 0  if location.blank?
		@location = location

		# @parentのセット
		if vpath.blank?
			@parent = nil	# rootより上には上がれない
		else
			@parent = vpath.parent.basename
			@parent = "root"  if @parent.blank?
		end

		# @filelistのセット
		@filelist = get_filelist(vpath)

		# 現在位置を更新
		update_filelist_visit(vpath, location)
		@vpath_from = session[:last_path_from]
	end

	# 移動したことを宣言
	# locationだと内部で使われているシンボルと被る
	def loc
		vpath = Vpath(session[:user_id], params[:path] || "")
		location = Vpath.reg_location(params[:location] || "").to_i

		# パラメータの検査
		if !valid_directory_path?(vpath)
			return render(nothing:true, status:400)
		end

		update_filelist_visit(vpath, location)
		return render(nothing:true)
	end

end
