class Directory

 private
	def initialize(vpath)
		@vpath = vpath
	end

 protected
	def make_dir_item(vpath)
		if File.directory?(vpath.r)
			return {
				type: :dir,
				vpath: vpath,
				datetime: File.mtime(vpath.r),
			}
		else
			return {
				type: :dir_missing,
				vpath: vpath,
			}
		end
	end

	def make_book_item(vpath)
		type = Book.type(vpath)
		if type == :images
			datetime = nil
			size = nil
		else
			datetime = File.mtime(vpath.r)
			size = File.size(vpath.r)
		end

		return {
			type: type,
			vpath: vpath,
			datetime: datetime,
			size: size,
		}
	end

	def make_text_item(vpath)
		return {
			type: :text,
			vpath: vpath,
		}
	end

	def make_html_item(vpath)
		return {
			type: :html,
			vpath: vpath,
		}
	end

	def make_audio_item(vpath)
		return {
			type: :audio,
			vpath: vpath,
		}
	end

	def make_video_item(vpath)
		return {
			type: :video,
			vpath: vpath,
		}
	end

	def make_file_mising_item(vpath)
		return {
			type: :file_missing,
			vpath: vpath,
		}
	end

	def _list
#		return [
#			{ type: :dir, vpath:"", datetime: Time.now, size: 0 }
#		]
		return []
	end

 public
 	attr_reader :vpath

	def self.factory(vpath)
		first, rest = vpath.v.split("/", 2)

		case first
		 when nil
			return RootDirectory.new(vpath)
		 when "*read"
			nil # TODO
		 when "*bookmark"
			nil # TODO
		 when "*tag"
			nil # TODO
		 else
			return FilesystemDirectory.new(vpath)
		end
	end

	def list
		r = _list
		r.sort_by! { |v| v[:vpath].v.to_s }
		return r
	end

end

############################################################

class RootDirectory < Directory

 private
	def initialize(vpath)
		@vpath = Vpath(vpath.u, "")
	end

 protected
	def _list
		r = [
			{type: :junction, vpath:Vpath(@vpath.u, "*read")},
			{type: :junction, vpath:Vpath(@vpath.u, "*bookmark")},
			{type: :junction, vpath:Vpath(@vpath.u, "*tag")},
		]

		Root.where(user_id:@vpath.u).each do |root|
			r << make_dir_item(Vpath(@vpath.u, root.virt_path))
		end

		return r
	end

end

############################################################

class FilesystemDirectory < Directory

 protected
	def _list
		r = []
		img_count = 0
		Dir.foreach(@vpath.r) do |entry|
			if entry.start_with?(".")
				# NOP
			else
				child = @vpath + entry
				child_r = File.join(@vpath.r, entry)
				if File.directory?(child_r)
					if image_only_dir?(child)
						r << make_book_item(child + "*img")
					else
						r << make_dir_item(child)
					end
				elsif File.file?(child_r)
					if extname_match?(YOMEYA_IMAGE_EXT, child.v)
						img_count += 1
					elsif extname_match?(YOMEYA_ALL_EXT, child.v)
						r << make_book_item(child)
					end
				else
					r << make_file_mising_item(child)
				end
			end
		end



#		vpath_glob(@vpath).each do |child|
#			if File.directory?(child.r)
#				if image_only_dir?(child)
#					r << make_book_item(child + "*img")
#				else
#					r << make_dir_item(child)
#				end
#			elsif File.file?(child.r)
#				if extname_match?(YOMEYA_IMAGE_EXT, child.v)
#					img_count += 1
#				elsif extname_match?(YOMEYA_ALL_EXT, child.v)
#					r << make_book_item(child)
#				end
#			else
#				r << make_file_mising_item(child)
#			end
#		end

		if img_count > 0
			r << make_book_item(@vpath + "*img")
		end

		return r
	end

end

############################################################

#	# 読みかけの本の一覧を作成する
#	def get_filelist_read(vpath)
#		r = []
#		Reading.where(user_id:session[:user_id]).reorder("touch_at desc") do |reading|
#			vpath = reading.vpath
#			type = case
#					when File.basename(vpath) == "*img"
#						:images
#					else
#						:file
#					end
#
#			r << {
#				label: vpath,
#				label2: "",
#				vpath: vpath,
#				type: type,
#			}
#		end
#
#		return r
#	end
