class CreateReadings < ActiveRecord::Migration
  def change
    create_table :readings do |t|
      t.references :user, null:false
      t.text :path, null:false
      t.string :location, null:false
      t.datetime :start_at
      t.datetime :end_at
      t.datetime :touch_at

      t.timestamps

      t.index [:user_id, :path], unique:true
      t.index [:user_id, :touch_at]
    end
  end
end
