# encoding: UTF-8
# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended that you check this file into your version control system.

ActiveRecord::Schema.define(version: 20140203125829) do

  create_table "bookmarkings", force: true do |t|
    t.integer  "user_id",    null: false
    t.text     "path",       null: false
    t.string   "location",   null: false
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "bookmarkings", ["user_id", "path"], name: "index_bookmarkings_on_user_id_and_path", unique: true
  add_index "bookmarkings", ["user_id", "updated_at"], name: "index_bookmarkings_on_user_id_and_updated_at"

  create_table "caches", force: true do |t|
    t.integer  "user_id",    null: false
    t.integer  "itemtype",   null: false
    t.text     "path",       null: false
    t.string   "location",   null: false
    t.binary   "data"
    t.datetime "access_at",  null: false
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "caches", ["user_id", "itemtype", "path", "location"], name: "index_caches_on_user_id_and_itemtype_and_path_and_location", unique: true

  create_table "logs", force: true do |t|
    t.integer  "user_id",    null: false
    t.string   "event",      null: false
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "logs", ["user_id", "updated_at"], name: "index_logs_on_user_id_and_updated_at"

  create_table "readings", force: true do |t|
    t.integer  "user_id",    null: false
    t.text     "path",       null: false
    t.string   "location",   null: false
    t.datetime "start_at"
    t.datetime "end_at"
    t.datetime "touch_at"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "readings", ["user_id", "path"], name: "index_readings_on_user_id_and_path", unique: true
  add_index "readings", ["user_id", "touch_at"], name: "index_readings_on_user_id_and_touch_at"

  create_table "roots", force: true do |t|
    t.integer  "user_id",    null: false
    t.string   "virt_path",  null: false
    t.text     "real_path",  null: false
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "roots", ["user_id", "virt_path"], name: "index_roots_on_user_id_and_virt_path", unique: true

  create_table "settings", force: true do |t|
    t.integer  "user_id",    null: false
    t.string   "key",        null: false
    t.string   "value",      null: false
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "settings", ["user_id", "key"], name: "index_settings_on_user_id_and_key", unique: true

  create_table "taggings", force: true do |t|
    t.integer  "tag_id",     null: false
    t.integer  "order",      null: false
    t.text     "path",       null: false
    t.string   "location",   null: false
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "taggings", ["tag_id", "order"], name: "index_taggings_on_tag_id_and_order", unique: true

  create_table "tags", force: true do |t|
    t.integer  "user_id",    null: false
    t.integer  "tag_id"
    t.integer  "order",      null: false
    t.string   "name",       null: false
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "tags", ["user_id", "name"], name: "index_tags_on_user_id_and_name"
  add_index "tags", ["user_id", "tag_id", "name"], name: "index_tags_on_user_id_and_tag_id_and_name", unique: true
  add_index "tags", ["user_id", "tag_id", "order"], name: "index_tags_on_user_id_and_tag_id_and_order"

  create_table "users", force: true do |t|
    t.string   "name",                                null: false
    t.string   "password"
    t.string   "pin"
    t.string   "secret"
    t.text     "last_path",              default: "", null: false
    t.string   "last_location",          default: "", null: false
    t.text     "filelist_last_path",     default: "", null: false
    t.string   "filelist_last_location", default: "", null: false
    t.datetime "auth_at"
    t.string   "access_from"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "users", ["name"], name: "index_users_on_name", unique: true

end
