﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi
{
    public class EcefVelocity
    {
        #region constructors
        /// <summary>
        ///     
        /// </summary>
        /// <param name="e">ENU E velocity in m/s</param>
        /// <param name="n">ENU N velocity in m/s</param>
        /// <param name="u">ENU U velocity in m/s</param>
        /// <param name="accuracy">Speed Accuracy Estimate in m/s</param>
        public EcefVelocity(double e, double n, double u, double accuracy)
        {
            E = e;
            N = n;
            U = u;
            Accuracy = accuracy;
        }

        #endregion

        #region properties
        public double E
        {
            get;
            set;
        }

        public double N
        {
            get;
            set;
        }

        public double U
        {
            get;
            set;
        }

        public double Accuracy
        {
            get;
            set;
        }

        public double Speed
        {
            get
            { 
                return Math.Sqrt(E * E + N * N + U * U);
            }
        }
        #endregion
    }
}
