﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi.Gps;

namespace YubeshiTest.GpsTest
{
    class WordTest
    {

        [Test]
        public void Encode()
        {
            Word w1;
            Word w2;
            w1 = new Word(0x8B6DE8);
            w2 = new Word(0x8B6DE8, (Word)2);
            Assert.AreEqual(w1.Parity, Word.GenerateParity(w1));
            Assert.AreEqual(w2.Parity, Word.GenerateParity(w2));

            w1 = new Word(0x8B6002);
            w2 = new Word(0x8B6002, (Word)2);
            Assert.AreEqual(w1.Parity, Word.GenerateParity(w1));
            Assert.AreEqual(w2.Parity, Word.GenerateParity(w2));

            w1 = new Word(0x8B8074);
            w2 = new Word(0x1BCD15, (Word)2);
            Assert.AreEqual(w1.Parity, Word.GenerateParity(w1));
            Assert.AreEqual(w2.Parity, Word.GenerateParity(w2));
        }

    }
}
