﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;
using Yubeshi.Ubx;
using P = YubeshiTest.UbxTest.SamplePackets;

namespace YubeshiTest.UbxTest
{

    class InfPacketTest
    {

        [Test]
        public void InfErrorTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(InfError.TryParse(P.InfError, out packet));
            InfError p = packet as InfError;
            Assert.AreEqual(Packet.MessageID.InfError, p.ID);
            Assert.AreEqual("!\0Error.", p.Message);
        }


        [Test]
        public void InfWarningTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(InfWarning.TryParse(P.InfWarning, out packet));
            InfWarning p = packet as InfWarning;
            Assert.AreEqual(Packet.MessageID.InfWarning, p.ID);
            Assert.AreEqual("!\0Warning.", p.Message);
        }


        [Test]
        public void InfNoticeTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(InfNotice.TryParse(P.InfNotice, out packet));
            InfNotice p = packet as InfNotice;
            Assert.AreEqual(Packet.MessageID.InfNotice, p.ID);
            Assert.AreEqual("!\0Notice.", p.Message);
        }

        [Test]
        public void InfTestTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(InfTest.TryParse(P.InfTest, out packet));
            InfTest p = packet as InfTest;
            Assert.AreEqual(Packet.MessageID.InfTest, p.ID);
            Assert.AreEqual("!\0Test.", p.Message);
        }

        [Test]
        public void InfDebugTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(InfDebug.TryParse(P.InfDebug, out packet));
            InfDebug p = packet as InfDebug;
            Assert.AreEqual(Packet.MessageID.InfDebug, p.ID);
            Assert.AreEqual("!\0Debug.", p.Message);
        }
    }
}
