﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Gps
{
    public class Subframe
    {
        #region constructors

        public Subframe(Subframe frame)
        {
            Words = frame.Words;
        }

        public Subframe(Word[] words)
        {
            Words = words;
        }

        public Subframe(byte[] raw)
        {
            Words = new Word[raw.Length / 4];
            for (int i = 0; i < Words.Length; ++i)
            {
                Words[i] = BitConverter.ToUInt32(raw, i * 4);
            }
        }
        

        protected Subframe()
        {
            Words = null;
        }

        #endregion

        #region properties

        public Word[] Words
        {
            get;
            protected set;
        }

        #endregion

    }
}
