/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Nmea
{
    /// <summary>
    ///     GNSS Range Residuals
    /// </summary>
    public class GpGrs : Packet
    {
        #region fields

        private static readonly byte[] header;
        private const int elementNum = 14;

        #endregion

        #region constructors
        
        static GpGrs()
        {
            header = Encoding.ASCII.GetBytes("$GPGRS,");
        }
        
        public GpGrs()
        {
        }

        public GpGrs(byte[] sentence)
            : this(sentence, GetElements(sentence, elementNum))
        {
        }

        private GpGrs(byte[] sentence, Elements elements)
        {
            Raw = new byte[elements.PacketLength];
            Array.Copy(sentence, Raw, elements.PacketLength);
            string[] v = elements.Values;
            TimeOfFix = ParseTime(v[0]);
        }

        #endregion

        #region properties

        public TimeSpan TimeOfFix
        {
            get;
            private set;
        }

        #endregion

        #region public method

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, header, elementNum, Build);
        }

        #endregion

        #region private method

        private static Packet Build(byte[] sentence, Elements elements)
        {
            return new GpGrs(sentence, elements);
        }

        #endregion
    }
}