﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class AidAlm : Packet
    {

        #region constructors
        public AidAlm()
            : base(MessageID.AidAlm)
        {
        }

        public AidAlm(uint svID)
            : base(
                new byte[]
                {
                    Packet.SyncCharacter1, Packet.SyncCharacter2,
                    0x0B, 0x30, // ID
                    0x01, 0x00, // length
                    (byte)svID, // svid
                    0x00, 0x00  // checksum
                })
        {
        }

        public AidAlm(byte[] sentence, int length)
            : base(sentence, length)
        {
            if (length > 14)
            {
                if (Week != 0)
                {
                    Words = new uint[8];
                    for (int i = 0; i < 8; ++i)
                    {
                        Words[i] = BitConverter.ToUInt32(Raw, 6 + 4 + i * 4);
                    }
                }
            }
        }

        #endregion

        #region properties

        public uint SvID
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 0);
            }
        }

        public uint Week
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 4);
            }
        }

        public uint[] Words
        {
            get;
            private set;
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            packet = null;
            if (sentence.Length < 14)
            {
                return false;
            }
            int length = BitConverter.ToUInt16(sentence, 4);
            return TryParse(sentence, out packet, 
                                        MessageID.RxmAlm, length, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new RxmAlm(sentence, length);
        }

        #endregion
    }
}
