﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class CfgRate : Packet
    {
        #region type definitions
        [Flags]
        public enum ReferenceTime : ushort
        {
            Utc = 0,
            Gps = 1,
            Local = 2,
        }

        #endregion

        #region constructors

        public CfgRate()
            : base(MessageID.CfgRate)
        {
        }

        public CfgRate(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        public CfgRate(int measurement, int navigation, ReferenceTime time)
            : base(
                new byte[]
                {
                    Packet.SyncCharacter1, Packet.SyncCharacter2,
                    0x06, 0x08, // ID
                    0x06, 0x00, // length
                    (byte)measurement, (byte)((int)measurement >> 8), // meas
                    (byte)navigation, (byte)((int)navigation >> 8), // nav
                    (byte)time, (byte)((int)time >> 8),       // time
                    0x00, 0x00  // checksum
                })
        {
            CheckSum = GenerateCheckSum();
        }

        #endregion

        #region properties

        public int MeasurementPeriod
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 0);
            }
        }

        public int NavigationRate
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 2);
            }
        }

        public ReferenceTime TimeSource
        {
            get
            {
                return (ReferenceTime)BitConverter.ToUInt16(Raw, 6 + 4);
            }
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            packet = null;
            if (sentence.Length < 6)
            {
                return false;
            }
            int length = BitConverter.ToUInt16(sentence, 4);
            if (length == 0 || length == 6)
            {
                return TryParse(sentence, out packet,
                                                MessageID.CfgRate, 6, Build);
            }
            return false;
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new CfgRate(sentence, length);
        }

        #endregion
    }
}
