﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class CfgRst : Packet
    {
        #region type definitions
        [Flags]
        public enum BbrMask : ushort
        {
            Hotstart = 0x0000,
            Warmstart = 0x0001,
            Coldstart = 0xFFFF,

            Ephemeris = 0x0001,
            Almanach = 0x0002,
            Health = 0x0004,
            Klobuchard = 0x0008,
            Position = 0x0010,
            ClockDrift = 0x0020,
            OscilatorParameter = 0x0040,
            UtcCorrectionParameters = 0x0080,
            Rtc = 0x0100
        }

        public enum ResetType : byte
        {
            HardwareResetImmediately = 0x00,
            ControlledSoftwareReset = 0x01,
            ControlledSoftwareResetGpsOnly = 0x02,
            HardwareResetAfterShutdown = 0x04,
            ControlledGpsStop = 0x08,
            ControlledGpsStart = 0x09,
        }
        #endregion

        #region constructors

        public CfgRst(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        public CfgRst(BbrMask mask, ResetType mode)
            : base(
                new byte[]
                {
                    Packet.SyncCharacter1, Packet.SyncCharacter2,
                    0x06, 0x04, // ID
                    0x04, 0x00, // length
                    (byte)mask, (byte)((int)mask >> 8), // mask
                    (byte)mode, // mode
                    0x00,       // reserved
                    0x00, 0x00  // checksum
                })
        {
            CheckSum = GenerateCheckSum();
        }

        #endregion

        #region properties

        public BbrMask Mask
        {
            get
            {
                return (BbrMask)BitConverter.ToUInt16(Raw, 6 + 0);
            }
        }

        public ResetType Mode
        {
            get
            {
                return (ResetType)Raw[6 + 2];
            }
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, MessageID.CfgRst, 4, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new CfgRst(sentence, length);
        }

        #endregion
    }
}
