﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class MonHw2 : Packet
    {
        #region type definitions
        public enum ConfigSource : byte
        {
            FlashImage = 102,
            Otp = 111,
            ConfigPins = 112,
            Rom = 114,
        }
        #endregion

        #region constructors

        public MonHw2(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public double ImbalanceI
        {
            get
            {
                return (sbyte)Raw[6 + 0] / 128.0;
            }
        }

        public double MagnitudeI
        {
            get
            {
                return Raw[6 + 1] / 255.0;
            }
        }

        public double ImbalanceQ
        {
            get
            {
                return (sbyte)Raw[6 + 2] / 128.0;
            }
        }


        public double MagnitudeQ
        {
            get
            {
                return Raw[6 + 3] / 255.0;
            }
        }

        public ConfigSource ConfigurationSource
        {
            get
            {
                return (ConfigSource)Raw[6 + 4];
            }
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, MessageID.MonHw2, 28, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new MonHw2(sentence, length);
        }

        #endregion
    }
}
