﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class NavSol : Packet
    {
        #region constructors

        public NavSol(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public GpsTime GpsTime
        {
            get
            {
                return new GpsTime(Week, TimeOfWeek);
            }
        }

        public decimal TimeOfWeek
        {
            get
            {
                uint tow = BitConverter.ToUInt32(Raw, 6 + 0);
                int ftow = BitConverter.ToInt32(Raw, 6 + 4);
                return tow * 1e-3m + ftow * 1e-9m;
            }
        }

        public int Week
        {
            get
            {
                return BitConverter.ToInt16(Raw, 6 + 8);
            }
        }

        public GpsFixType FixType
        {
            get
            {
                return (GpsFixType)Raw[6 + 10];
            }
        }

        public FixStatusFlag FixFlags
        {
            get
            {
                return (FixStatusFlag)Raw[6 + 11];
            }
        }

        public EcefCoordinate Position
        {
            get
            {
                int x = BitConverter.ToInt32(Raw, 6 + 12);
                int y = BitConverter.ToInt32(Raw, 6 + 16);
                int z = BitConverter.ToInt32(Raw, 6 + 20);
                double acc = BitConverter.ToUInt32(Raw, 6 + 24) * 0.01;
                return new EcefCoordinate(x * 0.01, y * 0.01, z * 0.01, acc);
            }
        }

        public EcefVelocity Velocity
        {
            get 
            {
                int vx = BitConverter.ToInt32(Raw, 6 + 28);
                int vy = BitConverter.ToInt32(Raw, 6 + 32);
                int vz = BitConverter.ToInt32(Raw, 6 + 36);
                uint vAcc = BitConverter.ToUInt32(Raw, 6 + 40);
                return new EcefVelocity(vx, vy, vz, vAcc);
            }
        }

        public int NumberOfSatelites
        {
            get;
            private set;
        }
        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, MessageID.NavSol, 52, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new NavSol(sentence, length);
        }

        #endregion
    }
}
