﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class NavVelEcef : Packet
    {
        #region constructors

        public NavVelEcef(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public decimal TimeOfWeek
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 0) * 1e-3m;
            }
        }

        public EcefVelocity Velocity
        {
            get
            { 
                int x = BitConverter.ToInt32(Raw, 6 + 4);
                int y = BitConverter.ToInt32(Raw, 6 + 8);
                int z = BitConverter.ToInt32(Raw, 6 + 12);
                double acc = BitConverter.ToUInt32(Raw, 6 + 16) * 0.01;
                return new EcefVelocity(x * 0.01, y * 0.01, z * 0.01, acc);
            }
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, 
                                            MessageID.NavVelEcef, 20, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new NavVelEcef(sentence, length);
        }

        #endregion
    }
}
