var Animation = enchant.Class.create({
	initialize: function (sprite){
		this.cnt = 0;
		this.cntUp = 0;
		this.cntDown = 0;
		this.accCnt = 0;
		this.maxY = -4;
		this.minY = 0;
		this.y = 0;
		this.speed = 0.5;
		this.sprite = sprite;
		this.status = EAnimStatus.UP;
		this.stop = false;

	},
	runAnim: function(){
		if(this.cnt <= this.maxY){
			this.status = EAnimStatus.DOWN;
		}
		else if(this.cnt >= this.minY){
			this.status = EAnimStatus.UP;
		}
		if(this.stop)return;
		if(this.status == EAnimStatus.UP){
			this.sprite.y -= this.speed;
			this.cnt -= this.speed;
			this.cntUp -= this.speed;
		}
		else if(this.status == EAnimStatus.DOWN){
			this.sprite.y += this.speed;
			this.cnt += this.speed;
			this.cntDown += this.speed;
		}
		if(this.cnt != (this.cntUp + this.cntDown)){
			console.log(this.cnt + "@" + this.cntUp + ":" + this.cntDown);
		}
		// console.log(this.cnt);
	},
	startAnim:function(){
		// console.log("start:" + this.cnt);
		this.stop = false;
	},
	stopAnim: function(){
		this.sprite.y -= this.cnt;
		this.cntUp = 0;
		this.cntDown = 0;
		this.cnt = 0;
		this.stop = true;
	},
});