
package com.yx.util.db.entity;

import java.util.ArrayList;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

import com.yx.common.TAStringUtils;

/**
 * @Title TAArrayList NameValuePair数组
 * @Package com.yx.util.db.entity
 * @Description NameValuePair数组
 * @author YXDroid
 * @date 2014-1-20
 * @version V1.0
 */
public class TAArrayList extends ArrayList<NameValuePair>
{

	private static final long serialVersionUID = 1L;

	@Override
	public boolean add(NameValuePair nameValuePair)
	{
		if (!TAStringUtils.isEmpty(nameValuePair.getValue()))
		{
			return super.add(nameValuePair);
		} else
		{
			return false;
		}
	}

	/**
	 * 添加数据
	 * 
	 * @param key
	 * @param value
	 * @return
	 */
	public boolean add(String key, String value)
	{
		return add(new BasicNameValuePair(key, value));
	}

}
