
package com.yx.util.download;

import java.util.ArrayList;
import java.util.List;
import com.yx.TAApplication;
import com.yx.common.TAStringUtils;

public class DownLoadConfigUtil
{
	public static final String PREFERENCE_NAME = "com.yyxu.download";
	public static final int URL_COUNT = 3;
	public static final String KEY_URL = "url";

	public static void storeURL(int index, String url)
	{
		TAApplication.getApplication().getCurrentConfig()
				.setString(KEY_URL + index, url);
	}

	public static void clearURL(int index)
	{
		TAApplication.getApplication().getCurrentConfig()
				.remove(KEY_URL + index);
	}

	public static String getURL(int index)
	{
		return TAApplication.getApplication().getCurrentConfig()
				.getString(KEY_URL + index, "");
	}

	public static List<String> getURLArray()
	{
		List<String> urlList = new ArrayList<String>();
		for (int i = 0; i < URL_COUNT; i++)
		{
			if (!TAStringUtils.isEmpty(getURL(i)))
			{
				urlList.add(getString(KEY_URL + i));
			}
		}
		return urlList;
	}

	private static String getString(String key)
	{
		// TODO Auto-generated method stub
		return TAApplication.getApplication().getCurrentConfig()
				.getString(key, "");
	}

}
