/// selef_convert_data() 
//  masashi shimakura 20140223

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iconv.h>
#include <errno.h>

#include "libms.h"


char * safe_convert_data(const char * input_code, const char * output_code, char * data, int * ret)
{
char * inbuf;
char * outbuf;
int max;
// int count;

max = (int)strlen(data);

if(max > 0){
   inbuf = (char *)calloc(max * 2, sizeof(char));
   outbuf = (char *)calloc(max * 2, sizeof(char));
   inbuf = safe_memcpy(inbuf, data, max);

   ret = convert(input_code, output_code, inbuf, outbuf, (max * 2));

   data = safe_memcpy(data, outbuf, (max * 2));

   free(inbuf);
   free(outbuf);
   }
else{
   fprintf(stderr,"safe_convert_data(): data size err.\n");
   }

return data;
}







