/******************************************************************************
*                           rtH[}bgRo[^                           
*        (g[rtH[}bgʂ̂rtH[}bgɕϊc[)        
* ---------------------------------------------------------------------------- 
*                    Copyright (C)2003N Oۏ(itmL)                    
* ---------------------------------------------------------------------------- 
*                                                                              
*  {vO̓t[E\tgEFAłBȂ́AFree Software Foundation  
*  \GNU ʌLgṕuo[WQv͂ȍ~̊eo[W  
*  ̒炢ꂩIÃo[W߂ɏ]Ė{vO  
*  ĔЕz܂͕ύX邱Ƃł܂B                                      
*                                                                              
*  {vO͗LpƂ͎v܂AЕzɂẮAsꐫyѓړIK  
*  ɂĂ̈Öق̕ۏ؂܂߂āAȂۏ؂sȂ܂BڍׂɂĂ  
*  GNU ʌLgpǂ݂B                                    
*                                                                              
*  Ȃ́A{vOƈꏏGNU ʌLgp̎ʂ󂯎Ă    
*  ͂łBłȂꍇ́AFree Software Foundation, Inc., 675 Mass Ave,   
*  Cambridge, MA 02139, USA ֎莆ĂB                           
*                                                                              
******************************************************************************/
#undef	DOS16
#define	DOS32
#undef	LINUX

#include	<stdio.h>
#ifndef	LINUX
#include	<conio.h>
#endif
#include	<string.h>

/* G[ExR[h` */
#define		ERR_CMPSW	( -1 )
#define		ERR_STYPE	( -2 )
#define		ERR_SWITCH	( -3 )
#define		ERR_NOSRC	( -4 )
#define		ERR_SRCTMPERR	( -5 )
#define		ERR_OPENSRC	( -6 )
#define		ERR_OPENDEST	( -7 )

#define		CAU_STYPE	( -1 )
#define		CAU_ADRLEN	( -2 )
#define		CAU_NOERR	0
#ifndef	LINUX
#define		CAU_ESC		255

/* ̑` */
#define		ESC	0x1b
#endif
#if defined( DOS16 )
const char	bitid[] = "16bit";
#endif
#if defined( DOS32 )
const char	bitid[] = "32bit";
#endif
#if defined( LINUX )
const char	bitid[] = "linux";
#endif

const char	dateid[] = __DATE__;
const char	vers[] = "version 1.00";

FILE	*in, *out;		/* ́Eo̓t@C|C^ */
char	format;			/* ϊtH[}bg */
char	inputcom;		/* ̓t@C␔ */
char	complement;		/* ␔I */
int	inrecsts, outrecsts;	/* R[hXe[^X S0-S9 */
char	headstr[80];		/* wb_ */
char	infname[128];		/* ̓t@C(R}hC) */
char	outfname[128];		/* o̓t@C(R}hC) */
int	sameflg;		/* ̓t@CƏo̓t@CO */

/**
*	QoCĝPUi𐔒lɂ
*	 in:	ϊPUi(QoCg)
*	out:	ϊꂽl(unsigned char)
*/
unsigned char	axtod( char *buf )
{
	char	i, tmp;
	unsigned char	ret;

	tmp = *( buf + 0 );
	if(( tmp >= '0' ) && ( tmp <='9' )){		/* ʃoCgϊ */
		i = tmp - '0';
	}
	else if(( tmp >= 'A' ) && ( tmp <='F' )){
		i = ( tmp - 'A' ) + 10;
	}
	else{
		i = 0;
	}
	ret = i << 4;
	tmp = *( buf + 1 );
	if(( tmp >= '0' ) && ( tmp <='9' )){		/* ʃoCgϊ */
		i = tmp - '0';
	}
	else if(( tmp >= 'A' ) && ( tmp <='F' )){
		i = ( tmp - 'A' ) + 10;
	}
	else{
		i = 0;
	}
	ret |= i;

	return	ret;
}


/**
*	PUi𐔒lɂ
*	 in:	ϊPUi(f[^͂W܂,NULL܂ł邱)
*	out:	ϊꂽl(unsigned long)
*/
unsigned long	axtol( char *buf )
{
	unsigned long	ret;
	int	i, j;
	char	tmp;

	if( strlen( buf ) > (size_t)8 ){		/* 񂪒 */
		return	0;
	}
	ret = 0;
	for( i = 0; *( buf + i ) != '\0'; i++ ){
		ret <<= 4;
		tmp = *( buf + i );
		if(( tmp >= '0' ) && ( tmp <='9' )){	/* PoCgϊ */
			j = tmp - '0';
		}
		else if(( tmp >= 'A' ) && ( tmp <='F' )){
			j = ( tmp - 'A' ) + 10;
		}
		else{
			j = 0;
		}
		ret |= j;
	}

	return	ret;
}


/**
*	wv\
*	 in:	Ȃ
*	out:	Ȃ
*/
void	disphelp( void )
{
	printf( "\n   ====== motorola S-record CONVerter(%s-version)  %s ======\n", bitid, vers );
	printf( "         UPDATED %s  Copyright (c)Junichi Tomaru 2003-2004\n\n", dateid );
	printf( "  USAGE: SCONV [FORMAT(S1,S2,S3) [SWITCH(-C1,-C2)] INPUTFILE [OUTPUTFILE]]\n" );
	printf( "----------------------------------------------------------------------------\n" );
	printf( " PARAMETERS:\n" );
	printf( "        FORMAT: OUTPUT FORMAT TYPE\n" );
	printf( "                 S1: S1 and S9 Record Format(16bit-Address)\n" );
	printf( "                 S2: S2 and S8 Record Format(24bit-Address)\n" );
	printf( "                 S3: S3 and S7 Record Format(32bit-Address)\n" );
	printf( "        SWITCH: OPTION SWITCH\n" );
	printf( "                 -C1: One's Complement  -C2: Two's Complement\n" );
	printf( "     INPUTFILE: SOURCE FILE NAME\n" );
	printf( "    OUTPUTFILE: DESTINATION FILE NAME\n" );
	printf( "\n" );
	printf( "                   HOMEPAGE: http://sconv.sourceforge.jp/\n" );
	printf( "----------------------------------------------------------------------------\n" );
	printf( "                  SCONV comes with ABSOLUTELY NO WARRANTY\n" );
	printf( " This is free software, and you are welcome to redistribute it under certain\n" );
	printf( " conditions, See the GNU General Public License for details.\n" );
}


/**
*	ϊAhXϊAhXɓ邩ׂ
*	 in:	srcaddr:ϊAhX
*		type:ϊ惌R[h^Cv
*	out:	O:AhX͈͓@OȊO:͈͊OR[h^Cv
*/
char	checkaddrrange( long srcaddr, char type )
{
	char	ret;

	ret = 0;
	if(( type == 1 ) || ( type == 9 )){	/* S1,S9(0000-FFFF) */
		if( srcaddr > 0xffff ){
			ret = type;
		}
	}
	else if(( type == 2 ) || ( type == 8 )){/* S2,S8(000000-FFFFFF) */
		if( srcaddr > 0xffffff ){
			ret = type;
		}
	}
	else if(( type == 3 ) || ( type == 7 )){/* S3,S7(00000000-FFFFFFFF) */
		if( srcaddr > 0xffffffff ){
			ret = type;
		}
	}

	return	ret;
}


/**
*	wb_񔲂o
*	 in:	rOR[hobt@擪|C^
*	out:	Ȃ
*/
void	getheadstr( char *buffer )
{
	char	len, i, j, buf[4], *p, c;

	buf[0] = *( buffer + 2 );		/* ϊoCgJEg */
	buf[1] = *( buffer + 3 );
	buf[2] = '\0';
	len = axtod( buf ) - 3;			/* `FbNT{AhXQoCg */
	if( len > 79 ){				/* l`wVX */
		len = 79;
	}
	p = buffer + 8;				/* f[^擪 */
	for( i = j = 0; i < len; i++ ){		/* PUiyA -> R[h */
		buf[0] = *p;
		p++;
		buf[1] = *p;
		p++;
		buf[2] = '\0';
		c = axtod( buf );
		if(( c >= 0x20 ) && ( c <= 0x7e )){/* pꃂ[hł\ł镶̂ */
			headstr[j] = c;
			j++;
		}
	}
	headstr[j] = '\0';
}


/**
*	R[hRs[(`FbNTvZȂďo͂̂)
*	 in:	R[hobt@擪|C^
*	out:	Ȃ
*/
void	recordcopy( char *str )
{
	char	len, buf[4], i, *p;
	unsigned char	sum;

	buf[0] = *( str + 2 );			/* ϊoCgJEg */
	buf[1] = *( str + 3 );
	buf[2] = '\0';
	len = axtod( buf );
	p = str + 2;				/* oCgJEgʒu */
	fputc( *( str + 0 ), out );		/* r */
	fputc( *( str + 1 ), out );
	sum = 0;
	for( i = 0; i < len; i++ ){		/* f[^o͐ɃRs[ȂZ */
		buf[0] = *p;
		fputc( *p, out );
		p++;
		buf[1] = *p;
		fputc( *p, out );
		p++;
		buf[2] = '\0';
		sum += axtod( buf );
	}
	sum = ~sum;				/* ](P̕␔) */
	if( complement == 2 ){			/* Q̕␔ɂ */
		sum++;
	}
	fprintf( out, "%02X\n", sum );		/* To */
}


/**
*	Psϊ[`
*	 in:ϊrR[h(Ps)
*	out:Xe[^XR[h(G[Ȃ)
*/
int	lineconvert( char *buffer )
{
	int	i, j;
	char	buf[16], *p;
	unsigned char	c;
	int	type;				/* ϊr^Cv */
	int	srcadrlen, destadrlen;		/* AhX */
	long	srcaddr;			/* ϊ̃AhX */
	char	*srcpnt;			/* ϊf[^̃|C^ */
	char	fmt;				/* ϊ̃R[h */
	unsigned char	oinsum;			/* ϊ`FbNT */
	unsigned char	srclen, destlen;	/* oCgJEg */
	unsigned char	datalen;		/* f[^ */
	unsigned char	insum;			/* ̓t@C`FbNT */
	unsigned char	sum;			/* `FbNT */

	p = buffer;
	while( *p == ' ' ){
		p++;
	}
	if( *p != 'S' ){			/* rtH[}bgł͂Ȃ */
		return	CAU_NOERR;
	}
	type = *( p + 1 ) - 0x30;		/* ϊr^Cv */
	switch( type ){				/* ϊAhX𓾂 */
		case 1:	/*  */
		case 9:	srcadrlen = 4;	/* S1,S9  QoCgAhX(S) */
			break;
		case 2:	/*  */
		case 8:	srcadrlen = 6;	/* S2,S8  RoCgAhX(U) */
			break;
		case 3:	/*  */
		case 7:	srcadrlen = 8;	/* S3,S7  SoCgAhX(W) */
			break;
		case 0:	getheadstr( p );	/* wb_𓾂ĉ */
		case 5:	recordcopy( p );	/* Ȃ̂ł̂܂܃Rs[ */
			break;
		default:	return CAU_STYPE;
	}
	inrecsts |= ( 1 << type );		/* ͑R[h^Cvo */
	if(( type == 0 ) || ( type == 5 )){
		outrecsts |= ( 1 << type );	/* o͑R[h^Cvɂo */
		return	CAU_NOERR;
	}
	buf[0] = *( p + 2 );			/* ϊoCgJEg */
	buf[1] = *( p + 3 );
	buf[2] = '\0';
	srclen = axtod( buf );
	c = ( srclen * 2 ) + 2;			/* ϊ`FbNTʒu */
	buf[0] = *( p + c );			/* ϊ`FbNT */
	buf[1] = *( p + c + 1 );
	buf[2] = '\0';
	oinsum = axtod( buf );
	datalen = srclen - ( srcadrlen / 2 ) - 1;/* f[^ */
	for( i = 0; i < srcadrlen; ){		/* ϊAhX */
		buf[i] = *( p + 4 + i );
		i++;
		buf[i] = *( p + 4 + i );
		i++;
	}
	buf[i] = '\0';
	srcaddr = axtol( buf );
	srcpnt = p + 4 + srcadrlen;		/* f[^̐擪ʒu */
	fmt = format;
	if( fmt == 1 ){				/* ϊtH[}bg */
		destadrlen = 4;
		if(( type >= 7 ) && ( type <= 9 )){/* rV`rX͕ϊƓAhXɓ */
			fmt = 9;
		}
	}
	else if( fmt == 2 ){
		destadrlen = 6;
		if(( type >= 7 ) && ( type <= 9 )){/* rV`rX͕ϊƓAhXɓ */
			fmt = 8;
		}
	}
	else if( fmt == 3 ){
		destadrlen = 8;
		if(( type >= 7 ) && ( type <= 9 )){/* rV`rX͕ϊƓAhXɓ */
			fmt = 7;
		}
	}
	if( checkaddrrange( srcaddr, fmt ) != 0 ){/* ϊłAhX͈͂ */
		return CAU_ADRLEN;
	}
	outrecsts |= ( 1 << fmt );		/* o͑R[h^Cvo */
	destlen = ( destadrlen / 2 ) + datalen + 1;	/* i[̕ */
	fprintf( out, "S%d%02X%0*lX", fmt, destlen, destadrlen, srcaddr );	/* rCށC,AhXo */
	insum = srclen;				/* ͑T */
	sum = destlen;				/* T */
	c = ( unsigned char )(( srcaddr >> 24 ) & 0xff );	/* AhXZ */
	c += ( unsigned char )(( srcaddr >> 16 ) & 0xff );
	c += ( unsigned char )(( srcaddr >> 8 ) & 0xff );
	c += ( unsigned char )( srcaddr & 0xff );
	insum += c;
	sum += c;
	for( j = 0; j < datalen; j++ ){	/* f[^o͐ɃRs[ȂZ */
		buf[0] = *srcpnt;
		fputc( buf[0], out );
		srcpnt++;
		buf[1] = *srcpnt;
		fputc( buf[1], out );
		srcpnt++;
		buf[2] = '\0';
		c = axtod( buf );
		insum += c;
		sum += c;
	}
	sum = ~sum;				/* ](P̕␔) */
	if( complement == 2 ){			/* Q̕␔ */
		sum++;
	}
	fprintf( out, "%02X\n", sum );		/* To */
	insum = ~insum;				/* ](P̕␔) */
	if( oinsum == insum ){			/* P̕␔ŔrĂ݂ */
		inputcom = 1;
	}
	else{
		insum++;
		if( oinsum == insum ){		/* Q̕␔ŔrĂ݂ */
			inputcom = 2;
		}
		else{
			inputcom = 0;		/* TႤ */
		}
	}

	return	CAU_NOERR;
}


/**
*	XCb`Eݒ
*	 in:	R}hC̃IvV(argv)
*	out:	-1: ␔wG[
*		-2: rtH[}bgwG[
*		-3: XCb`G[
*		1,2,3FϊtH[}bg^Cv
*/
int	setswitch( char **point )
{
	int	ret;
	char	*p, p1, p2;

	complement = 1;				/* ftHg͂P̕␔ */
	p1 = 2;					/* ̓t@Cʒu */
	p2 = 3;					/* o̓t@Cʒu */
	p = *( point + 1 );			/* argv[1] */
	if(( *p == 'S' ) || ( *p == 's' )){	/* rtH[}bgw肩 */
		p++;
		if(( *p == '1' ) && ( *( p + 1 ) == '\0' )){		/* S1 */
			ret = 1;
		}
		else if(( *p == '2' ) && ( *( p + 1 ) == '\0' )){	/* S2 */
			ret = 2;
		}
		else if(( *p == '3' ) && ( *( p + 1 ) == '\0' )){	/* S3 */
			ret = 3;
		}
		else{
			return	ERR_STYPE;
		}
	}
	else{
		return	ERR_SWITCH;
	}
	p = *( point + 2 );			/* argv[2] */
	if( p == NULL ){
		return	ERR_NOSRC;		/* XCb`͖ƍl */
	}
	if(( *p == '-' )){			/* XCb` */
		p++;
		if(( *p == 'C' ) || ( *p == 'c' )){	/* ␔wXCb` */
			p++;
			if(( *p == '1' ) && ( *( p + 1 ) == '\0' )){	/* P̕␔ */
				complement = 1;
			}
			else if(( *p == '2' ) && ( *( p + 1 ) == '\0' )){/* Q̕␔ */
				complement = 2;
			}
			else{
				return	ERR_CMPSW;
			}
			p1++;
			p2++;
		}
		else{
			return	ERR_SWITCH;
		}
	}
	if( *( point + p1 ) != NULL ){
		strcpy( infname, *( point + p1 ));	/* ̓t@C */
	}
	if( *( point + p2 ) != NULL ){
		strcpy( outfname, *( point + p2 ));	/* o̓t@C */
	}

	return	ret;
}


/**
*	rR[h^Cv\
*	 in:	R[h
*	out:	Ȃ
*/
void	disprecord( int sts )
{
	char	i;
	int	j;

	printf( " RECORD:" );
	for( i = 0, j = 1; i < 10; i++ ){
		if(( sts & j ) == j ){			/* ܂܂Ă郌R[h */
			putchar( '0' + i );
		}
		else{
			putchar( '-' );			/* ̑ */
		}
		j = ( j << 1 );
	}
	printf( "\n" );
}


/**
*	xbZ[W\
*	 in:	err:G[R[h
*		line:sԍ
*	out:	Ȃ
*/
void	cautionmessage( int err, unsigned long line )
{
	switch( err ){
		case CAU_STYPE:	fprintf( stderr, "\nCAUTION:SOURCE RECORD TYPE NOT SUPPORT(LINE:%lu). STOP.\n", line );
				break;
		case CAU_ADRLEN:fprintf( stderr, "\nCAUTION:ADDRESS LENGTH RANGE OVER(LINE:%lu). STOP.\n", line );
				break;
		default:	fprintf( stderr, "\nCAUTION:OTHER ERROR(LINE:%lu). STOP.\n", line );
				break;
	}
}


/**
*	G[bZ[W
*	 in:	err:G[R[h
*		str:ǉ\
*	out:	Ȃ
*/
void	errormessage( int err, char *str )
{
	switch( err ){
		case ERR_CMPSW:		fprintf( stderr, "ERROR:COMPLEMENT SWITCH ERROR.\n" );
					break;
		case ERR_STYPE:		fprintf( stderr, "ERROR:S FORMAT TYPE ERROR.\n" );
					break;
		case ERR_SWITCH:	fprintf( stderr, "ERROR:INVALID SWITCH.\n" );
					break;
		case ERR_NOSRC:		fprintf( stderr, "ERROR:NO INPUT FILE NAME.\n" );
					break;
		case ERR_SRCTMPERR:	fprintf( stderr, "ERROR:TEMPORARY FILE ERROR.(CANNOT OPEN).\n" );
					break;
		case ERR_OPENSRC:	fprintf( stderr, "ERROR:CANNOT OPEN SOURCE FILE(%s).\n", str );
					break;
		case ERR_OPENDEST:	fprintf( stderr, "ERROR:CANNOT OPEN DESTINATION FILE(%s).\n", str );
					break;
		default:		break;
	}
}


/**
*	IbZ[W
*	 in:	Ȃ
*	out:	Ȃ
*/
void	endmessage( void )
{
	fprintf( stderr, "\nFILE CONVERT COMPLETE.\n" );/* I */
	printf( "\n--- INPUT FILE REPORT ---\n" );
	if( headstr[0] != '\0' ){		/* rȌ񂠂 */
		printf( " HEADER:%s\n", headstr );
	}
	if( inrecsts != 0 ){			/* R[h̋L */
		disprecord( inrecsts );
	}
	if( inputcom == 0 ){			/* ͑`FbNT␔ */
		printf( " COMPLEMENT:NOT MATCH\n" );
	}
	else{
		printf( " COMPLEMENT:%d\n", inputcom );
	}
	printf( "\n--- OUTPUTUT FILE REPORT ---\n" );
	if( outrecsts != 0 ){			/* R[h̋L */
		disprecord( outrecsts );
	}
	printf( " COMPLEMENT:%d\n", complement );/* o͑`FbNT␔ */
}


/**
*	C
*	 in:	argc:R}hC̈̐(vO܂)
*		argv:R}hC̈()̃|C^z
*	out:	G[R[h
*/
int	main( int argc, char *argv[] )
{
	char	buf[128];			/* Psobt@ */
	unsigned long	line;			/* ϊꂽC */
	int	b, err;

	sameflg = 0;
	infname[0] = outfname[0] = '\0';
	if( argc == 1 ){		/* t@C^XCb`w肪Ƃ */
		b = 0;
	}
	else{
		b = setswitch( argv );		/* XCb`ׂ */
	}
	if( b < 0 ){				/* XCb`G[ */
		errormessage( b, NULL );
		return	b;
	}
	else if( b == 0 ){			/* SCONV̂Ƃ̓wv\ */
		disphelp( );
	}
	else{
		format = (char)b;		/* tH[}bg */
		if( infname[0] == '\0' ){	/* ̓t@CȂ */
			errormessage( ERR_NOSRC, NULL );
			return	( -4 );
		}
		if(( strcmp( infname, outfname ) == 0 ) || ( outfname[0] == '\0' )){
					/* t@Co̓t@CȂ */
			sameflg = 1;
		}
		in = fopen( infname, "rt" );	/* ϊt@CI[v */
		if( in == NULL ){
			errormessage( ERR_OPENSRC, infname );
			return	( -5 );
		}
		if( sameflg == 1 ){
			out = fopen( "sconv.tmp", "wt" );/* ꎞt@CI[v */
		}
		else{
			out = fopen( outfname, "wt" );	/* ϊt@CI[v */
		}
		if( out == NULL ){
			fclose( in );
			if( sameflg == 1 ){
				errormessage( ERR_SRCTMPERR, NULL );
				return	( -6 );
			}
			else{
				errormessage( ERR_OPENDEST, outfname );
				return	( -7 );
			}
		}
		inrecsts = outrecsts = 0;	/* Xe[^XNA */
		headstr[0] = '\0';
		for( line = 1; !feof( in ); ){	/* tH[}bgϊ */
#ifndef	LINUX
			if( kbhit( ) != 0 ){	/* L[͂ */
				if( getch( ) == ESC ){	/* drb */
					err = CAU_ESC;
					break;
				}
			}
#endif
			if( fgets( buf, 127, in ) != NULL ){	/* Psǂݏo */
				err = lineconvert( buf );
				if( err != 0 ){	/* G[甲 */
					break;
				}
			}
			fprintf( stderr, "\rConverted Lines %lu", line );
			line++;
		}
		fclose( in );			/* Î߁Aŕ */
		fclose( out );
		if( err == CAU_NOERR ){		/* I */
			endmessage( );
			if( sameflg == 1 ){
				remove( infname );
				rename( "sconv.tmp", infname );
			}
		}
		else{
			if( sameflg == 1 ){
				remove( "sconv.tmp" );
			}
			else{
				remove( outfname );
			}
			if( err < 0 ){
				cautionmessage( err, line );	/* G[\ */
			}
		}
	}
	return	0;
}

/* end of sconv.c */
