/* * * Sdg_Yacc.y * * *
 * ʸϴؿ
 * * * * * * * * * * */
%{
#define YY_Sdg_Parser_STYPE yy_Sdg_Parser_stype
%}

%name Sdg_Parser
%define LSP_NEEDED
%define ERROR_BODY =0
%define LEX_BODY =0

%header{
#include"Sdg_Error.h"
#include"Sdg_Script.h"
#include<iostream>
#include <string>
using namespace std;

#undef YY_DECL
#define YY_DECL int Sdg_Lexer::yylex(YY_Sdg_Parser_STYPE *val)

#ifndef FLEXFIX
#define FLEXFIX YY_Sdg_Parser_STYPE *val
#define FLEXFIX2 val
#endif
%}

%union{
	int num;
}

%token <num> NUMBER
%token EOL
%left '+' '-'
%left '*' '/'
%right UMINUS
%type <num> expr
%start input

%%

input: /*null*/
	| input line {}
	;

line:	expr EOL { cout << "result=" << $1 << endl;}
	| EOL
	;

expr:	expr '+' expr { $$ = $1 + $3;}
	| expr '-' expr { $$ = $1 - $3;}
	| expr '*' expr { $$ = $1 * $3;}
	| expr '/' expr { $$ = $1 / $3;}
	| '(' expr ')' { $$ = $2;}
	| NUMBER { $$ = $1;}
	| '-' expr %prec UMINUS {$$ = -$2;}
	;
%%
