package sdl4gcj.video;

import java.io.File;

public class Screen extends Surface
{
	// class methods

	/**
	* SDL_SetVideoMode()
	**/
	public static native Screen setVideoMode(int width, int height, int bpp, int flags);

	/**
	* SDL_GetVideoSurface()
	**/
	public static native Screen getVideoSurface();

	/**
	* SDL_GetVideoInfo()
	**/
	public static native VideoInfo getVideoInfo();

	// class variables
	private static Screen singleton = null;


	// constructors
	private Screen() { }

	// instance methods

	/**
	* Make sure the given area is updated.
	* This is equivalent to SDL_UpdateRect() function.
	**/
	public native void updateRect(int x, int y, int w, int h);

	/**
	* Make sure the given area is updated.
	**/
	public void updateRect(Rect rect)
	{
		this.updateRect(rect.getX(), rect.getY(), 
			rect.getW(), rect.getH());
	}

	/**
	* Make sure the whole of screen is updated.
	**/
	public void updateRect()
	{
		this.updateRect(0, 0, 0, 0);
	}

	/**
	* Make sure the given areas are updated.
	* This is equivalent to SDL_UpdateRects() function.
	**/
	public native void updateRects(Rect[] rects);

	public native void flip();

	public void freeSurface(){}

}

