import sdl4gcj.Sys;
import sdl4gcj.SDLConstants;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.Mouse;

public class RepeatTest implements SDLConstants
{
	static final String BG_IMAGE_PATH = "images/maze.bmp";
	static final String ICON_IMAGE_PATH = "images/icon.bmp";

	public static void main(String[] args)
	{
		if (Sys.init(SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Init() fail");
			System.exit(0);
		}

		try
		{
			Screen screen = Screen.setVideoMode(640, 480, 32, 
				SDL_SWSURFACE);

			// load background image
			Surface bg = Surface.loadBMP(BG_IMAGE_PATH);
			bg.displayFormat();

			Surface icon = Surface.loadBMP(ICON_IMAGE_PATH);
			icon.setColorKey(SDL_SRCCOLORKEY|SDL_RLEACCEL);
			icon.displayFormat();

			// repeat blit bg
			screen.repeatSurface(bg);
			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				while (event.pollEvent() > 0)
				{
					switch (event.type)
					{
						case SDL_MOUSEMOTION :
							if (Mouse.getMouse().getButtonState(SDL_BUTTON_LEFT))
							{
								screen.blitSurface(icon, event.motion.x, event.motion.y);
								screen.updateRect();
							}
							break;
						case SDL_MOUSEBUTTONUP :
							if (event.buttonup.button == SDL_BUTTON_RIGHT)
							{
								screen.repeatSurface(bg);
								screen.updateRect();
							}
							break;
						case SDL_KEYDOWN :
							if ((event.keydown.sym == SDLK_ESCAPE) ||
								(event.keydown.sym == SDLK_q))
								done = true;
							break;
						case SDL_QUIT:
							done = true;
							break;
						default:
							break;
					}
				}

			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			Sys.quit();
		}
	}
}
