package sdl4gcj;

public final class Sys implements SysConstants
{
	// system

	/**
	* SDL_Init()
	* Initialize SDL system.
	* <ul>
	* <li>SDL_INIT_TIMER</li>
	* <li>SDL_INIT_AUDIO</li>
	* <li>SDL_INIT_VIDEO</li>
	* <li>SDL_INIT_CDROM</li>
	* <li>SDL_INIT_JOYSTICK</li>
	* <li>SDL_INIT_NOPARACHUTE</li>
	* <li>SDL_INIT_EVENTTHREAD</li>
	* <li>SDL_INIT_EVERYTHING</li>
	* </ul>
	**/
	public static native final int init(int flags);

	/**
	* SDL_InitSubSystem()
	* Initialize subsystem.
	**/
	public static native final int initSubSystem(int flags);

	/**
	* SDL_WasInit()
	* Check which subsystems are initialized.
	**/
	public static native final int wasInit(int flags);

	/**
	* SDL_QuitSubSystem() 
	* Finalize subsystem.
	**/
	public static native final void quitSubSystem(int flags);

	/**
	* SDL_Quit()
	* Finalize SDL system.
	**/
	public static native final void quit();

	/**
	* SDL_Delay()
	* Wait a specified number of miliseconds.
	**/
	public static native final void delay(long ms);

	/**
	* SDL_GetTicks()
	* Get a number of miliseconds since the SDL system initialization.
	**/
	public static native final long getTicks();

	private Sys(){}
}
