package sdl4gcj.video;

import sdl4gcj.SDLException;

import java.io.File;
import java.io.InputStream;
import java.io.IOException;

public class Surface implements VideoConstants
{
	// instance variables
	protected gnu.gcj.RawData implementation = null;
	protected PixelFormat format = null;
	protected byte[] pixelArray = null;

	// class methods
	public static native String getVideoDriverName();

	public static native Surface loadBMP(String filePath);
	public static Surface loadBMP(File file)
	{
		return loadBMP(file.getAbsolutePath());
	}

	public native static Surface loadBMP(byte[] bytes, int offset, int length);

	/**
	* same as loadBMP(bytes, 0, bytes.length);
	**/
	public static Surface loadBMP(byte[] bytes)
	{
		return loadBMP(bytes, 0, bytes.length);
	}

	public static Surface loadBMP(InputStream inputStream)
	{
		Surface result = null;
		byte[] bytes = new byte[4096];
		int index = 0;
		int data = -1;
		
		try
		{
			while ((data = inputStream.read()) != -1)
			{
				if (index >= bytes.length)
					bytes = new byte[bytes.length*2];
				bytes[index++] = (byte)data;
			}
			result = loadBMP(bytes, 0, index);
		}
		catch (IOException ioe)
		{
			ioe.printStackTrace();
		}

		return result;
	}

	public static Surface createRGBSurface(int flags, 
		int width, int height, int bpp,
		int rmask, int gmask, int bmask, int amask)
	{
		return new Surface(flags, width, height, bpp,
			rmask, gmask, bmask, amask);
	}

	// constructors
	public Surface() 
	{ 
	}

	public Surface(int flags, 
		int width, int height, int bpp,
		int rmask, int gmask, int bmask, int amask)
	{ 
		this.initWithRGBSurface(flags, 
			width, height, bpp,
			rmask, gmask, bmask, amask);
	}

	// instance methods
	public native int getFlags();
	public native int getW();
	public native int getH();
	public native int getPitch();

	public native void saveBMP(String filePath);
	public void saveBMP(File file)
	{
		this.saveBMP(file.getAbsolutePath());
	}

	public native int blitSurface(Surface surface, 
		int sx, int sy, int sw, int sh, int dx, int dy);
	public native int blitSurface(Surface surface, int dx, int dy);
	public native int blitSurface(Surface surface);

	public int repeatSurface(Surface surface)
	{
		int targetW = this.getW();
		int targetH = this.getH();
		int srcW = surface.getW();
		int srcH = surface.getH();
		for (int y = 0; y <= targetH; y += srcH)
		{
			for (int x = 0;x <= targetW; x += srcW)
			{
				int result = this.blitSurface(surface, x, y);
				if (result != 0) return result;
			}
		}
		return 0;
	}

	public native void fillRect(
		int sx, int sy, int sw, int sh, int color);

	public native void fillRect(int color);

	public void fillRect(Rect rect, int color)
	{
		this.fillRect(rect.getX(), rect.getY(),
			rect.getW(), rect.getH(), color);
	}

	public native void setColorKey(int flags, int colorkey);

	public native void setColorKey(int flags);

	public void setColorKey()
	{
		this.setColorKey(SDL_SRCCOLORKEY|SDL_RLEACCEL);
	}

	public native boolean setClipRect(int x, int y, int w, int h);

	public native boolean setClipRect();

	public native int[] getClipRect();

	public native int setAlpha(int flags, int alpha);

	public native void displayFormat();

	public native void displayForamtAlpha();

	public native void convertSurface(PixelFormat format, int flags);

	public native Surface cloneSurface();

	public native PixelFormat getPixelFormat();

	public native void setPalette(Color[] palette);

	public native void setPalette(Palette palette);

	public Palette getPalette()
	{
		return this.getPixelFormat().getPalette();
	}

	public int mapRGB(Color color)
	{
		return this.getPixelFormat().mapRGB(color);
	}

	public int mapRGB(int red, int green, int blue)
	{
		return this.getPixelFormat().mapRGB(red, green, blue);
	}

	public int mapRGBA(Color color)
	{
		return this.getPixelFormat().mapRGBA(color);
	}

	public int mapRGBA(int red, int green, int blue, int alpha)
	{
		return this.getPixelFormat().mapRGBA(red, green, blue, alpha);
	}

	public int[] getRGB(int pixel)
	{
		return this.getPixelFormat().getRGB(pixel);
	}

	public int[] getRGBA(int pixel)
	{
		return this.getPixelFormat().getRGBA(pixel);
	}

	public native byte[] getPixels();
	public native void setPixels(byte[] pixels);

	public native void freeSurface();

	protected void finalize() throws Throwable
	{
		this.freeSurface();
		super.finalize();
	}

	private native void initWithRGBSurface(int flags, 
		int width, int height, int bpp,
		int rmask, int gmask, int bmask, int amask);
}

