import sdl4gcj.Sys;
import sdl4gcj.SDLConstants;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

class CrossCursor extends Cursor
{
	static private final int WIDTH = 8;
	static private final int HEIGHT = 8;
	static private final int HOT_X = 3;
	static private final int HOT_Y = 3;

	static private final byte[] data =
	{
		(byte)0x10, 
		(byte)0x10, 
		(byte)0x10, 
		(byte)0xFF, 
		(byte)0x10, 
		(byte)0x10, 
		(byte)0x10, 
		(byte)0x10, 
	};

	static private final byte[] mask =
	{
		(byte)0x38, 
		(byte)0x38, 
		(byte)0xFF, 
		(byte)0xFF, 
		(byte)0xFF, 
		(byte)0x38, 
		(byte)0x38, 
		(byte)0x38, 
	};

	public CrossCursor()
	{
		super(data, mask, WIDTH, HEIGHT, HOT_X, HOT_Y);
	}
}

class SquareCursor extends Cursor
{
	static private final int WIDTH = 8;
	static private final int HEIGHT = 8;
	static private final int HOT_X = 3;
	static private final int HOT_Y = 3;
	static private final byte[] dataAndMask =
	{
		(byte)0xFF, 
		(byte)0x81, 
		(byte)0x81, 
		(byte)0x81, 
		(byte)0x81, 
		(byte)0x81, 
		(byte)0x81, 
		(byte)0xFF, 
	};


	public SquareCursor()
	{
		super(dataAndMask, dataAndMask, WIDTH, HEIGHT, HOT_X, HOT_Y);
	}
}

public class CursorTest implements SDLConstants
{
	private static Screen screen;
	private static Cursor[] cursors;
	private static int[] colors;

	private static Cursor[] getCursors()
	{
		if (cursors == null)
		{
			cursors = new Cursor[2];
			cursors[0] = new CrossCursor();
			cursors[1] = new SquareCursor();
		}
		return cursors;
	}

	private static int[] getColors()
	{
		if (colors == null)
		{
			colors = new int[2];
			colors[0] = screen.mapRGB(Color.RED);
			colors[1] = screen.mapRGB(Color.MAGENTA);
		}
		return colors;
	}

	private static Cursor getCursor(int cursorX, int cursorY)
	{
		Cursor[] cursors = getCursors();
		int areaH = screen.getH() / cursors.length;
		int index = cursorY / areaH;
		return cursors[index];
	}

	private static void drawBackground()
	{
		Cursor[] cursors = getCursors();
		int[] colors = getColors();
		
		int areaH = screen.getH() / cursors.length;
		for (int i = 0;i < cursors.length;i++)
		{
			screen.fillRect(0, i * areaH, screen.getW(), areaH, colors[i]);
		}
		screen.updateRect();
	}

	public static void main(String[] args)
	{
		if (Sys.init(SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Init() fail");
			System.exit(0);
		}


		try
		{
			SDLOptionParser optParser = new SDLOptionParser(
				640, 480, 8, 
				Surface.SDL_SWSURFACE|Surface.SDL_ANYFORMAT);
			optParser.parse(args);

			screen = Screen.setVideoMode(
				optParser.getScreenWidth(), optParser.getScreenHeight(),
				optParser.getBitsPerPixel(),
				optParser.getVideoFlags());

			drawBackground();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
					case SDL_MOUSEMOTION :
						// change cursor
						screen.setCursor(
							getCursor(event.motion.x, event.motion.y));
						break;
					case SDL_MOUSEBUTTONDOWN :
						break;
					case SDL_MOUSEBUTTONUP :
						if (event.buttonup.button == SDL_BUTTON_LEFT)
							screen.showCursor(true);
						else if (event.buttonup.button == SDL_BUTTON_RIGHT)
							screen.showCursor(false);
						break;
					case SDL_KEYDOWN :
						if ((event.keydown.sym == SDLK_ESCAPE) ||
							(event.keydown.sym == SDLK_q))
							done = true;
						break;
					case SDL_QUIT:
						done = true;
						break;
					default:
						break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			Sys.quit();
		}
	}
}
