import java.util.Timer;
import java.util.TimerTask;

import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.event.*;

class Blueman implements Rect
{
	Surface[] images = new Surface[4];
	int[] pattern = {0, 1, 2, 1, 0, 1, 2, 1, 0, 1, 2, 1, 3, 3, 3, 3, 3, 3};
	int index = 0;
	int x, y, w, h;

	Blueman()
	{
		for (int i = 0;i < 4;i++)
		{
			this.images[i] = Surface.loadBMP("images/nf-b-" + (i+1) +".bmp");
			this.images[i].setColorKey();
			this.images[i].displayFormat();
		}
		this.w = this.images[0].getW();
		this.h = this.images[0].getH();
		this.x = 0;
		this.y = 0;
	}

	public int getX() { return this.x; }
	public int getY() { return this.y; }
	public int getW() { return this.w; }
	public int getH() { return this.h; }

	public void setX(int x) { this.x = x; }
	public void setY(int y) { this.y = y; }

	void goNext()
	{
		this.index = (this.index + 1) % pattern.length;
	}

	void paint(Surface targetSurface)
	{
		Surface image = this.images[this.pattern[this.index]];
		targetSurface.blitSurface(image, x, y);
	}

	int getMsecPerFrame()
	{
		return 100;
	}

}

class BluemanUpdateTask extends TimerTask
{
	Blueman blueman;
	BluemanUpdateTask(Blueman blueman)
	{
		this.blueman = blueman;
	}

	public void run()
	{
		this.blueman.goNext();
	}
}

public class TimerAnimation implements SDLConstants
{
	public static void main(String[] args)
	{
		if (Sys.init(SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Init() fail");
			System.exit(0);
		}

		try
		{
			Screen screen = Screen.setVideoMode(320, 240, 16, 
				SDL_SWSURFACE|SDL_ANYFORMAT);
			int bgPixel = screen.mapRGB(Color.WHITE);

			Blueman blueman = new Blueman();
			blueman.setX((screen.getW() - blueman.getW()) / 2);
			blueman.setY((screen.getH() - blueman.getH()) / 2);

			Timer timer = new Timer(true); // daemon thread
			TimerTask task = new BluemanUpdateTask(blueman);
			timer.scheduleAtFixedRate(task, 500L, blueman.getMsecPerFrame());

			screen.fillRect(bgPixel);
			blueman.paint(screen);
			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();

			while (!done)
			{
				while (event.pollEvent() > 0)
				{
					switch (event.type)
					{
						case SDLEvent.SDL_MOUSEBUTTONDOWN :
							if (task != null)
							{
								task.cancel();
								task = null;
							}
							else
							{
								task = new BluemanUpdateTask(blueman);
								timer.scheduleAtFixedRate(task, 0, blueman.getMsecPerFrame());
							}
							break;
						case SDLEvent.SDL_KEYDOWN :
							if ((event.keydown.sym == SDLK_ESCAPE) ||
								(event.keydown.sym == SDLK_q))
								done = true;
							break;
						case SDLEvent.SDL_QUIT:
							done = true;
							break;
						default:
							break;
					}
				}

				screen.fillRect(bgPixel);
				blueman.paint(screen);
				screen.updateRect(blueman);
				Sys.delay(30);
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			Sys.quit();
		}
	}
}
