package sdl4gcj.video;

import java.io.File;

public class Screen extends Surface
{
	// class methods

	/**
	* SDL_SetVideoMode()
	**/
	public static native Screen setVideoMode(int width, int height, int bpp, int flags);

	/**
	* SDL_GetVideoSurface()
	**/
	public static native Screen getVideoSurface();

	/**
	* SDL_GetVideoInfo()
	**/
	public static native VideoInfo getVideoInfo();

	/**
	* SDL_SetGamma(float redgamma, float greengamma, float, bluegamma)
	**/
	public static native void setGamma(float redgamma, float greengamma, float bluegamma);

	/**
	* SDL_SetGammaRamp(Uint16* redtable, Uint16* greentable, Uint16* bluetable)
	**/
	public static native void setGammaRamp(int[] redtable, int[] greentable, int[] bluetable);

	/**
	* SDL_SetGammaRamp(redTable, null, null)
	**/
	public static void setRedGammaRamp(int[] redTable)
	{
		setGammaRamp(redTable, null, null);
	}

	/**
	* SDL_SetGammaRamp(greenTable, null, null)
	**/
	public static void setGreenGammaRamp(int[] greenTable)
	{
		setGammaRamp(null, greenTable, null);
	}

	/**
	* SDL_SetGammaRamp(blueTable, null, null)
	**/
	public static void setBlueGammaRamp(int[] blueTable)
	{
		setGammaRamp(null, null, blueTable);
	}

	/**
	* SDL_GetGammaRamp(redtable, NULL, NULL)
	**/
	public static native int[] getRedGammaRamp();

	/**
	* SDL_GetGammaRamp(NULL, greentable, NULL)
	**/
	public static native int[] getGreenGammaRamp();

	/**
	* SDL_GetGammaRamp(NULL, NULL, bluetable)
	**/
	public static native int[] getBlueGammaRamp();

	/**
	* SDL_GL_SetAttribute(SDL_GLattr attr, int value)
	**/
	public static native void glSetAttribute(int attr, int value);

	/**
	* SDL_GL_GetAttribute(SDL_GLattr attr)
	**/
	public static native int glGetAttribute(int attr);

	// class variables
	private static Screen singleton = null;


	// constructors
	private Screen() { }

	// instance methods

	/**
	* Make sure the given area is updated.
	* This is equivalent to SDL_UpdateRect() function.
	**/
	public native void updateRect(int x, int y, int w, int h);

	/**
	* Make sure the given area is updated.
	**/
	public void updateRect(Rect rect)
	{
		this.updateRect(rect.getX(), rect.getY(), 
			rect.getW(), rect.getH());
	}

	/**
	* Make sure the whole of screen is updated.
	**/
	public void updateRect()
	{
		this.updateRect(0, 0, 0, 0);
	}

	/**
	* Make sure the given areas are updated.
	* This is equivalent to SDL_UpdateRects() function.
	**/
	public native void updateRects(Rect[] rects);

	/**
	* SDL_Flip(SDL_Surface* screen)
	**/
	public native void flip();

	/**
	* SDL_GL_SwapBuffers()
	**/
	public native void glSwapBuffers();


	/**
	* SDL_SetCursor(SDL_Cursor* cursor) 
	**/
	public void setCursor(Cursor cursor)
	{
		Cursor.setCursor(cursor);
	}

	/**
	* SDL_Cursor* SDL_GetCursor() 
	**/
	public Cursor getCursor()
	{
		return Cursor.getCursor();
	}

	/**
	* SDL_ShowCursor(int toggle) 
	**/
	public void showCursor(boolean toggle)
	{
		Cursor.showCursor(toggle);
	}

	public void convertSurface(PixelFormat format, int flags){}

	public void freeSurface(){}

}

