import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

public class GammaTest implements SDLConstants
{
	public static void main(String[] args)
	{
		Sys.init(SDL_INIT_VIDEO);

		SDLOptionParser optParser = new SDLOptionParser(
			640, 480, 8, 
			Surface.SDL_SWSURFACE|Surface.SDL_ANYFORMAT);
		optParser.parse(args);

		try
		{
			Screen screen = Screen.setVideoMode(
				optParser.getScreenWidth(), optParser.getScreenHeight(),
				optParser.getBitsPerPixel(),
				optParser.getVideoFlags());

			Surface bg = Surface.loadBMP("images/logo.bmp");
			if (screen.getPalette() != null)
				screen.setPalette(bg.getPalette());

			bg.displayFormat();
			screen.repeatSurface(bg);
			screen.updateRect();

			float gamma = 1.0F;
			Keyboard.getKeyboard().enableKeyRepeat(500, 50);

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
				case SDL_KEYDOWN :
					switch (event.keydown.sym)
					{
					case SDLK_UP :
					case SDLK_DOWN :
						if (event.keydown.sym == SDLK_UP)
						{
							gamma += 0.2F;
							if (gamma > 10.0) gamma = 10.0F;
						}
						else
						{
							gamma -= 0.2F;
							if (gamma < 0.0) gamma = 0.0F;
						}
						Screen.setGamma(gamma, gamma, gamma);
						System.out.println("gamma : " + gamma);
						break;
					case SDLK_r :
						// reverse 
						int[] redTable = Screen.getRedGammaRamp();
						int[] greenTable = Screen.getGreenGammaRamp();
						int[] blueTable = Screen.getBlueGammaRamp();
						for (int i = 0;i < redTable.length;i++)
						{
							redTable[i] = 0xFFFF - redTable[i];
							greenTable[i] = 0xFFFF - greenTable[i];
							blueTable[i] = 0xFFFF - blueTable[i];
						}
						Screen.setGammaRamp(redTable, greenTable, blueTable);
						break;
					case SDLK_q :
					case SDLK_ESCAPE :
						done = true;
						break;
					default:
						break;
					}
					break;
				case SDL_QUIT :
					done = true;
					break;
				default:
					break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			Sys.quit();
		}
	}
}
