import sdl4gcj.SDLConstants;
import java.util.HashMap;
import java.util.ArrayList;

public class SDLOptionParser implements SDLConstants
{
	private HashMap options;

	private int defaultWidth;
	private int defaultHeight;
	private int defaultBpp;
	private int defaultFlags;

	public SDLOptionParser(int width, int height, int bpp, int flags)
	{
		this.defaultWidth = width;
		this.defaultHeight = height;
		this.defaultBpp = bpp;
		this.defaultFlags = flags;
	}

	public SDLOptionParser()
	{
		this(640, 480, 8, SDL_SWSURFACE);
	}

	public String[] parse(String[] args)
	{
		this.options = null;
		ArrayList restArguments = new ArrayList();
		for (int i = 0;i < args.length;i++)
		{
			if (args[i].equals("-hw"))
			{
				this.getOptions().put("-hw", "true");
			}
			else if (args[i].equals("-flip"))
			{
				this.getOptions().put("-flip", "true");
			}
			else if (args[i].equals("-fullscreen"))
			{
				this.getOptions().put("-fullscreen", "true");
			}
			else if (args[i].equals("-bpp") && i+1 < args.length)
			{
				i++;
				this.getOptions().put("-bpp", args[i]);
			}
			else if (args[i].equals("-width") && i+1 < args.length)
			{
				i++;
				this.getOptions().put("-width", args[i]);
			}
			else if (args[i].equals("-height") && i+1 < args.length)
			{
				i++;
				this.getOptions().put("-height", args[i]);
			}
			else
			{
				restArguments.add(args[i]);
			}
		}
		return (String[])restArguments.toArray(new String[0]);
	}

	private HashMap getOptions()
	{
		if (this.options == null)
			this.options = new HashMap();
		return this.options;
	}

	public int getVideoFlags()
	{
		int videoFlags = this.defaultFlags;

		if (this.getOptions().get("-hw") != null)
			videoFlags ^= SDL_HWSURFACE;

		if (this.getOptions().get("-fullscreen") != null)
			videoFlags ^= SDL_FULLSCREEN;

		if (this.getOptions().get("-flip") != null)
			videoFlags ^= SDL_DOUBLEBUF;

		if (this.getOptions().get("-bpp") != null)
			videoFlags &= ~SDL_ANYFORMAT;

		return videoFlags;
	}

	public int getScreenWidth()
	{
		return this.getIntegerOption("-width", this.defaultWidth);
	}

	public int getScreenHeight()
	{
		return this.getIntegerOption("-height", this.defaultHeight);
	}

	public int getBitsPerPixel()
	{
		return getIntegerOption("-bpp", this.defaultBpp);
	}

	private int getIntegerOption(String optName, int defaultValue)
	{
		int value = defaultValue;
		String valeuStr = (String)this.getOptions().get(optName);
		try 
		{
			value = Integer.parseInt(valeuStr);
		}
		catch (NumberFormatException e) { }

		return value;
	}
}

