package sdl4gcj;

/** \mainpage
* sdl4gcj is a GCJ(http://gcc.gnu.org/java/) binding to 
* SDL(Simple DirectMedia Layer : http://www.libsdl.org/).
* 
* Packages:
* <dl>
* <dt> sdl4gcj </dt>
* <dd> SDL System. initialization and finalization.</dd>
* <dt> sdl4gcj.input </dt>
* <dd> Input System. keyboard, mouse and joystick.</dd>
* <dt> sdl4gcj.event </dt>
* <dd> Event System.</dd>
* <dt> sdl4gcj.video </dt>
* <dd> Video System. Drawing 2d grpahics system</dd>
* <dt> sdl4gcj.cdrom </dt>
* <dd> Playing audio CD.</dd>
* <dt> sdl4gcj.mixer </dt>
* <dd> Audio Mixer. SDL_mixer wrapper.</dd>
* <dt> sdl4gcj.image </dt>
* <dd> Image Loader. SDL_image wrapper.</dd>
* </dl>
**/


/**
* 
**/
public final class Sys implements SysConstants
{
	// system

	/**
	* SDL_Init()
	* Initialize SDL system.
	* <ul>
	* <li>SDL_INIT_TIMER</li>
	* <li>SDL_INIT_AUDIO</li>
	* <li>SDL_INIT_VIDEO</li>
	* <li>SDL_INIT_CDROM</li>
	* <li>SDL_INIT_JOYSTICK</li>
	* <li>SDL_INIT_NOPARACHUTE</li>
	* <li>SDL_INIT_EVENTTHREAD</li>
	* <li>SDL_INIT_EVERYTHING</li>
	* </ul>
	**/
	public static native final int init(int flags);

	/**
	* Initialize subsystem.
	* SDL_InitSubSystem()
	**/
	public static native final int initSubSystem(int flags);

	/**
	* Check which subsystems are initialized.
	* SDL_WasInit()
	**/
	public static native final int wasInit(int flags);

	/**
	* Finalize subsystem.
	* SDL_QuitSubSystem() 
	**/
	public static native final void quitSubSystem(int flags);

	/**
	* Finalize SDL system.
	* SDL_Quit()
	**/
	public static native final void quit();

	/**
	* Get version of compile library.
	* @return version of compile library 
	**/
	public static native Version compiledVersion();

	/**
	* Get version of linked library. ( SDL_Linked_Version() )
	* @return version of linked library
	**/
	public static native Version linkedVersion();

	/**
	* Wait a specified number of miliseconds.
	* SDL_Delay()
	* @param ms delay time (milisecond)
	**/
	public static native final void delay(long ms);

	/**
	* Get a number of miliseconds since the SDL system initialization.
	* SDL_GetTicks()
	**/
	public static native final long getTicks();

	/**
	* Get a native byte order.
	* SDL_BYTEORDER
	* @return byte order SDL_LIL_ENDIAN or SDL_BIG_ENDIAN 
	**/
	public static native final int byteOrder();

	private Sys(){}
}
