package sdl4gcj.video;

public interface VideoConstants
{
	/**
	* Surface is in system memory
	**/
	int SDL_SWSURFACE   = 0x00000000;

	/**
	* Surface is in video memory
	**/
	int SDL_HWSURFACE   = 0x00000001;

	/**
	* Use asynchronous blits if possible
	**/
	int SDL_ASYNCBLIT   = 0x00000004;

	// Available for SDL_SetVideoMode() 

	/**
	* Allow any video depth/pixel-format
	**/
	int SDL_ANYFORMAT   = 0x10000000;

	/**
	* Surface has exclusive palette
	**/
	int SDL_HWPALETTE   = 0x20000000;

	/**
	* Set up double-buffered video mode
	**/
	int SDL_DOUBLEBUF   = 0x40000000;

	/**
	* Surface is a full screen display
	**/
	int SDL_FULLSCREEN  = 0x80000000;

	/**
	* Create an OpenGL rendering context
	**/
	int SDL_OPENGL      = 0x00000002;

	/**
	* Create an OpenGL rendering context and use it for blitting 
	**/
	int SDL_OPENGLBLIT  = 0x0000000A;

	/**
	* This video mode may be resized 
	**/
	int SDL_RESIZABLE   = 0x00000010;

	/**
	* No window caption or edge frame 
	**/
	int SDL_NOFRAME     = 0x00000020;

	// Used internally (read-only)

	/**
	* Blit uses hardware acceleration
	**/
	int SDL_HWACCEL     = 0x00000100;

	/**
	* Blit uses a source color key
	**/
	int SDL_SRCCOLORKEY = 0x00001000;

	/**
	* Private flag
	**/
	int SDL_RLEACCELOK  = 0x00002000;

	/**
	* Surface is RLE encoded
	**/
	int SDL_RLEACCEL    = 0x00004000;

	/**
	* Blit uses source alpha blending 
	**/
	int SDL_SRCALPHA    = 0x00010000;

	/**
	* Surface uses preallocated memory
	**/
	int SDL_PREALLOC    = 0x01000000;

	// Available for SDL_GL_SetAttribute(), SDL_GL_GetAttribute() 
    int SDL_GL_RED_SIZE            =  0;
    int SDL_GL_GREEN_SIZE          =  1;
    int SDL_GL_BLUE_SIZE           =  2;
    int SDL_GL_ALPHA_SIZE          =  3;
    int SDL_GL_BUFFER_SIZE         =  4;
    int SDL_GL_DOUBLEBUFFER        =  5;
    int SDL_GL_DEPTH_SIZE          =  6;
    int SDL_GL_STENCIL_SIZE        =  7;
    int SDL_GL_ACCUM_RED_SIZE      =  8;
    int SDL_GL_ACCUM_GREEN_SIZE    =  9;
    int SDL_GL_ACCUM_BLUE_SIZE     = 10;
    int SDL_GL_ACCUM_ALPHA_SIZE    = 11;
    int SDL_GL_STEREO              = 12;
    int SDL_GL_MULTISAMPLEBUFFERS  = 13;
    int SDL_GL_MULTISAMPLESAMPLES  = 14;
}
