package sdl4gcj.mixer;

import sdl4gcj.SDLSystem;
import sdl4gcj.SDLConstants;

public interface MixerConstants
{
	int AUDIO_U8     = 0x0008; // Unsigned 8-bit samples 
	int AUDIO_S8     = 0x8008; // Signed 8-bit samples 
	int AUDIO_U16LSB = 0x0010; // Unsigned 16-bit samples 
	int AUDIO_S16LSB = 0x8010; // Signed 16-bit samples 
	int AUDIO_U16MSB = 0x1010; // As above, but big-endian byte order 
	int AUDIO_S16MSB = 0x9010; // As above, but big-endian byte order 
	int AUDIO_U16    = (SDLSystem.byteOrder() == SDLConstants.SDL_LIL_ENDIAN) ? AUDIO_U16LSB : AUDIO_U16MSB;
	int AUDIO_S16    = (SDLSystem.byteOrder() == SDLConstants.SDL_LIL_ENDIAN) ? AUDIO_S16LSB : AUDIO_S16MSB;

	// Mix_Fading
	int MIX_NO_FADING    = 0;
	int MIX_FADING_OUT   = 1;
	int MIX_FADING_IN    = 2;

	// Mix_MusicType;
	int MUS_NONE     = 0;
	int MUS_CMD      = 1;
	int MUS_WAV      = 2;
	int MUS_MOD      = 3;
	int MUS_MID      = 4;
	int MUS_OGG      = 5;
	int MUS_MP3      = 6;

	int MIX_CHANNELS = 8;
	int MIX_MAX_VOLUME = 128;

	int MIX_DEFAULT_FREQUENCY = 22050;
	int MIX_DEFAULT_FORMAT = AUDIO_S16;
	int MIX_DEFAULT_CHANNELS = 2;
}

