import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;


public class Test implements SDLConstants
{
	static final String SAVE_FILE = "saved.bmp";

	public static void main(String[] args)
	{
		if (SDLSystem.init(SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Init() fail");
			System.exit(0);
		}
		System.out.println(" Compiled SDL Version : " + SDLSystem.compiledVersion());
		System.out.println("   Linked SDL Version : " + SDLSystem.linkedVersion());
		if (SDLSystem.byteOrder() == SDL_LIL_ENDIAN)
			System.out.println("SDLSystem.byteOrder() : SDL_LIL_ENDIAN = " + SDLSystem.byteOrder());
		else
			System.out.println("SDLSystem.byteOrder() : SDL_BIG_ENDIAN = " + SDLSystem.byteOrder());

		try
		{
			Screen screen = Screen.setVideoMode(640, 480, 32, SDL_SWSURFACE|SDL_ANYFORMAT);
			Surface memory = screen.cloneSurface();

			int bgPixel = screen.mapRGB(Color.BLACK);

			Surface icon = Surface.loadBMP("images/icon.bmp");
			icon.setColorKey(SDL_SRCCOLORKEY|SDL_RLEACCEL);
			icon.displayFormat();

			ImageFont font = new ImageFont();

			int w = icon.getW();
			int h = icon.getH();
			int x = (screen.getW() - w) / 2;
			int y = (screen.getH() - h) / 2;

			screen.fillRect(bgPixel);
			font.draw(screen, "Push 's' key to save screen into memory", 0, 0);
			font.draw(screen, "Push 'l' key to load from memory", 0, 32);
			font.draw(screen, "Push 'c' key to clear screen.", 0, 64);
			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
					case SDL_MOUSEMOTION :
						// draw icon
						if (Mouse.getMouse().getButtonState(SDL_BUTTON_LEFT))
						{
							x = event.motion.x - w/2;
							y = event.motion.y - h/2;
							screen.blitSurface(icon, x, y);
							screen.updateRect();
						}
						break;
					case SDL_KEYDOWN :
						if ((event.keydown.sym == SDLK_ESCAPE) ||
							(event.keydown.sym == SDLK_q))
						{
							done = true;
						}
						else if (event.keydown.sym == SDLK_s)
						{
							memory.freeSurface();
							memory = screen.cloneSurface();
							System.out.println("Screen is saved into memory.");
						}
						else if (event.keydown.sym == SDLK_l)
						{
							screen.blitSurface(memory);
							screen.updateRect();
							System.out.println("Screen is loaded from memory. ");
						}
						else if (event.keydown.sym == SDLK_c)
						{
							screen.fillRect(bgPixel);
							screen.updateRect();
						}
						break;
					case SDL_QUIT:
						done = true;
						break;
					default:
						break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
