package sdl4gcj.video;

import java.io.File;

public class Screen extends Surface
{
	// class methods

	/**
	* Set up a video mode with the specified width, height and bits-per-pixel.
	* SDL_SetVideoMode(int w, int h, int bpp, int flags) wrapper.
	**/
	public static native Screen setVideoMode(int width, int height, int bpp, int flags);

	/**
	* Get the current display surface.
	* SDL_GetVideoSurface()
	**/
	public static native Screen getVideoSurface();

	/**
	* Get the information about the video hardware.
	* SDL_GetVideoInfo()
	**/
	public static native VideoInfo getVideoInfo();

	/**
	* Sets the color gamma function for the display.
	* SDL_SetGamma(float redgamma, float greengamma, float, bluegamma)
	**/
	public static native void setGamma(float redgamma, float greengamma, float bluegamma);

	/**
	* Sets the color gamma lookup tables for the display.
	* SDL_SetGammaRamp(Uint16* redtable, Uint16* greentable, Uint16* bluetable)
	**/
	public static native void setGammaRamp(int[] redtable, int[] greentable, int[] bluetable);

	/**
	* Sets the red gamma lookup tables for the display.
	* SDL_SetGammaRamp(redTable, null, null)
	**/
	public static void setRedGammaRamp(int[] redTable)
	{
		setGammaRamp(redTable, null, null);
	}

	/**
	* Sets the green gamma lookup tables for the display.
	* SDL_SetGammaRamp(greenTable, null, null)
	**/
	public static void setGreenGammaRamp(int[] greenTable)
	{
		setGammaRamp(null, greenTable, null);
	}

	/**
	* Sets the blue gamma lookup tables for the display.
	* SDL_SetGammaRamp(blueTable, null, null)
	**/
	public static void setBlueGammaRamp(int[] blueTable)
	{
		setGammaRamp(null, null, blueTable);
	}

	/**
	* Gets the red gamma lookup tables for the display.
	* SDL_GetGammaRamp(redtable, NULL, NULL)
	**/
	public static native int[] getRedGammaRamp();

	/**
	* Gets the green gamma lookup tables for the display.
	* SDL_GetGammaRamp(NULL, greentable, NULL)
	**/
	public static native int[] getGreenGammaRamp();

	/**
	* Gets the blue gamma lookup tables for the display.
	* SDL_GetGammaRamp(NULL, NULL, bluetable)
	**/
	public static native int[] getBlueGammaRamp();

	/**
	* Set window title and icon name.
	* SDL_WM_SetCaption(char* title, char* icon) wrapper.
	**/
	public static native void setCaption(String windowCaption,
		String iconCaption);

	/**
	* Set the window caption.
	* SDL_WM_SetCaption(windowCaption, NULL) wrapper.
	**/
	public static void setWindowCaption(String windowCaption)
	{
		setCaption(windowCaption, null);
	}

	/**
	* Set the icon caption.
	* SDL_WM_SetCaption(NULL, iconCaption) wrapper.
	**/
	public static void setIconCaption(String iconCaption)
	{
		setCaption(null, iconCaption);
	}

	/**
	* Gets the window caption.
	* SDL_WM_GetCaption(char** title, char* icon) wrapper.
	**/
	public static native String getWindowCaption();

	/**
	* Gets the icon caption.
	* SDL_WM_GetCaption(char** title, char* icon) wrapper.
	**/
	public static native String getIconCaption();

	/**
	* Set the icon for the display window.
	* Win32 icons must be 32x32.
	* This method must be called  before the first call to Screen.setVideoMode().
	* It takes an icon surface, and a mask in MSB format.
	* SDL_WM_SetIcon(SDL_Surface* icon, Uint8* mask) wrapper.
	**/
	public static native void setIcon(Surface icon, byte[] mask);

	/**
	* Set the icon for the display window.
	* Win32 icons must be 32x32.
	* This method must be called  before the first call to Screen.setVideoMode().
	* The entire icon surface will be used as the icon.
	* SDL_WM_SetIcon(SDL_Surface* icon, Uint8* mask) wrapper.
	**/
	public static void setIcon(Surface icon)
	{
		setIcon(icon, null);
	}

	/**
	* SDL_GL_SetAttribute(SDL_GLattr attr, int value)
	**/
	public static native void glSetAttribute(int attr, int value);

	/**
	* SDL_GL_GetAttribute(SDL_GLattr attr)
	**/
	public static native int glGetAttribute(int attr);

	// class variables
	private static Screen singleton = null;

	// constructors
	private Screen() { }

	// instance methods

	/**
	* Make sure the given area is updated.
	* This is equivalent to SDL_UpdateRect() function.
	**/
	public native void updateRect(int x, int y, int w, int h);

	/**
	* Make sure the given area is updated.
	**/
	public void updateRect(Rect rect)
	{
		this.updateRect(rect.getX(), rect.getY(), 
			rect.getW(), rect.getH());
	}

	/**
	* Make sure the whole of screen is updated.
	**/
	public void updateRect()
	{
		this.updateRect(0, 0, 0, 0);
	}

	/**
	* Make sure the given areas are updated.
	* This is equivalent to SDL_UpdateRects() function.
	**/
	public native void updateRects(Rect[] rects);

	/**
	* SDL_Flip(SDL_Surface* screen)
	**/
	public native void flip();

	/**
	* SDL_GL_SwapBuffers()
	**/
	public native void glSwapBuffers();

	/**
	* Set the currently active mouse cursor.
	* SDL_SetCursor(SDL_Cursor* cursor) wrapper.
	**/
	public void setCursor(Cursor cursor)
	{
		Cursor.setCursor(cursor);
	}

	/**
	* Get the currently active mouse cursor.
	* SDL_Cursor* SDL_GetCursor() wrapper.
	**/
	public Cursor getCursor()
	{
		return Cursor.getCursor();
	}

	/**
	* Toggle whether or not the cursor is shown on the screen.
	* SDL_ShowCursor(int toggle) wrapper.
	**/
	public void setCursorVisible(boolean toggle)
	{
		Cursor.setVisible(toggle);
	}

	/**
	* Returns <code>true</code> if the cursor is visible.
	* SDL_ShowCursor(int toggle) wrapper.
	**/
	public boolean isCursorVisible()
	{
		return Cursor.isVisible();
	}

	/**
	* Iconify/Minimise the window.
	* SDL_WM_IconifyWindow() 
	**/
	public native void iconifyWindow();

	/**
	* Toggle fullscreen mode.
	* Toggles the application between windowed and 
	* fullscreen mode, if supported.
	* SDL_WM_ToggleFullScreen() wrapper.
	* @return 0 on failure or 1 on success.
	**/
	public native int toggleFullScreen();

	/**
	* Grab mouse and keyboard input.
	* SDL_WM_GrabInput() wrapper.
	* @return new grab mode
	**/
	public native boolean grabInput(boolean grabMode);

	/**
	* Grab mouse and keyboard input.
	* SDL_WM_GrabInput() wrapper.
	**/
	public native void setGrabInputMode(boolean grabMode);

	/**
	* Get grab mode for mouse and keyboard input.
	* SDL_WM_GrabInput() wrapper.
	* @return current grab mode
	**/
	public native boolean getGrabInputMode();

	public void convertSurface(PixelFormat format, int flags){}

	public void freeSurface(){}

}

