/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/ttf/TTFSystem.h"

#include "sdl4gcj/ttf/FontConstants.h"
#include "sdl4gcj/Version.h"
#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <gcj/javaprims.h>
#include <stdlib.h>
#include <string.h>

#include <SDL.h>
#include <SDL_ttf.h>


using namespace sdl4gcj::ttf;
using sdl4gcj::Version;
using sdl4gcj::SDLException;

// function

// class methods

Version*
TTFSystem::compiledVersion()
{
	JvInitClass(&TTFSystem::class$);

	SDL_version nativeVersion;
	TTF_VERSION(&nativeVersion);

	sdl4gcj::Version* compiledVersion = new Version(
		nativeVersion.major,
		nativeVersion.minor,
		nativeVersion.patch);

	return compiledVersion;
}

Version*
TTFSystem::linkedVersion()
{
	JvInitClass(&TTFSystem::class$);

	const SDL_version* nativeVersion = TTF_Linked_Version();

	sdl4gcj::Version* linkedVersion = new Version(
		nativeVersion->major,
		nativeVersion->minor,
		nativeVersion->patch);

	return linkedVersion;
}

void
TTFSystem::init()
{
	JvInitClass(&TTFSystem::class$);
	if (TTF_Init() != 0)
		throw new SDLException();
	
	return ;
}

jboolean
TTFSystem::wasInit()
{
	JvInitClass(&TTFSystem::class$);

	return TTF_WasInit();
}

void
TTFSystem::quit()
{
	JvInitClass(&TTFSystem::class$);

	TTF_Quit();
}


