import java.util.Random;
import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

class GreenPalette extends Palette
{
	public GreenPalette()
	{
		super(512);
		
		int i = 0;
		for (i = 0;i < 128;i++)
		{
			this.setColorAt(i, 0, i*2, 0);
		}
		for (i = 0;i < 128;i++)
		{
			this.setColorAt(128+i, 0, 0xff-i*2, 0);
		}

		for (i = 0;i < 256;i++)
		{
			this.setColorAt(i+256, this.getColorAt(i));
		}
	}
}

class RainbowPalette extends Palette
{
	public RainbowPalette()
	{
		super(512);
		
		int i = 0;
		int j = 0;
		for (j = 0;j <= 0xff;j += 6)
		{
			this.setColorAt(i, 0xff, 0, j);
			i++;
		}
		for (j = 0xff;j >= 0;j -= 6)
		{
			this.setColorAt(i, j, 0, 0xff);
			i++;
		}
		for (j = 0;j <= 0xff;j += 6)
		{
			this.setColorAt(i, 0, j, 0xff);
			i++;
		}
		for (j = 0xff;j >= 0;j -= 6)
		{
			this.setColorAt(i, 0, 0xff, j);
			i++;
		}
		for (j = 0;j <= 0xff;j += 6)
		{
			this.setColorAt(i, j, 0xff, 0);
			i++;
		}
		for (j = 0xff;j >= 0;j -= 6)
		{
			this.setColorAt(i, 0xff, j, 0);
			i++;
		}

		for (i = 0;i < 256;i++)
		{
			this.setColorAt(i+256, this.getColorAt(i));
		}
	}
}

public class RainbowPaletteTest implements SDLConstants
{
	public static final int PALETTE_SIZE = 256;
	public static final int SCREEN_BPP = 8;

	public static void main(String[] args)
	{
		SDLSystem.init(SDLSystem.SDL_INIT_VIDEO);

		SDLOptionParser optParser = new SDLOptionParser(
			640, 480, SCREEN_BPP, SDL_HWSURFACE|SDL_HWPALETTE);
		optParser.parse(args);

		try
		{
			Screen screen = Screen.setVideoMode(
				optParser.getScreenWidth(), optParser.getScreenHeight(),
				SCREEN_BPP, optParser.getVideoFlags());
			screen.setCursorVisible(false);
			// init palette
			Palette palette = new RainbowPalette();
//			Palette palette = new GreenPalette();
			int paletteIndex = 0;
			screen.setPalette(palette, paletteIndex, 0, PALETTE_SIZE);

			// init screen
			for (int i = PALETTE_SIZE-1;i >= 0;i--)
			{
				int w = screen.getW() * i / PALETTE_SIZE;
				int h = screen.getH() * i / PALETTE_SIZE;
				int x = (screen.getW() - w)/2;
				int y = (screen.getH() - h)/2;
				screen.fillRect(x, y, w, h, PALETTE_SIZE-i);
			}
			screen.flip();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				long startTicks = SDLSystem.getTicks();
				while (event.pollEvent() > 0)
				{
					switch (event.type)
					{
						case SDLEvent.SDL_KEYDOWN :
							if (event.keydown.sym == Keyboard.SDLK_ESCAPE ||
								event.keydown.sym == Keyboard.SDLK_q )
							{
								done = true;
							}
							break;
						case SDLEvent.SDL_QUIT:
							done = true;
							break;
						default:
							break;
					}
				}
				paletteIndex = (paletteIndex + 1) % PALETTE_SIZE;
				screen.setPalette(palette, paletteIndex, 0, PALETTE_SIZE);
				SDLSystem.delay(16);
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
