import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;


public class SaveBMPTest implements SDLConstants
{
	static final String SAVE_FILE = "saved.bmp";

	public static void main(String[] args)
	{
		SDLSystem.init(SDLSystem.SDL_INIT_VIDEO);
		try
		{
			Screen screen = Screen.setVideoMode(640, 480, 32, SDL_SWSURFACE|SDL_ANYFORMAT);

			int bgPixel = screen.mapRGB(Color.BLACK);

			Surface icon = Surface.loadBMP("images/icon.bmp");
			icon.setColorKey(SDL_SRCCOLORKEY|SDL_RLEACCEL);
			icon.displayFormat();

			ImageFont font = new ImageFont();

			int w = icon.getW();
			int h = icon.getH();
			int x = (screen.getW() - w) / 2;
			int y = (screen.getH() - h) / 2;

			screen.fillRect(bgPixel);
			font.draw(screen, "Push 's' key to save bmp.", 0, 0);
			font.draw(screen, "Push 'c' key to clear screen.", 0, 32);
			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
					case SDL_MOUSEMOTION :
						// draw icon
						if (Mouse.getMouse().getButtonState(SDL_BUTTON_LEFT))
						{
							x = event.motion.x - w/2;
							y = event.motion.y - h/2;
							screen.blitSurface(icon, x, y);
							screen.updateRect();
						}
						break;
					case SDL_KEYDOWN :
						if ((event.keydown.sym == SDLK_ESCAPE) ||
							(event.keydown.sym == SDLK_q))
						{
							done = true;
						}
						else if (event.keydown.sym == SDLK_s)
						{
							screen.saveBMP(SAVE_FILE);
							System.out.println("Screen is saved to " + SAVE_FILE);
						}
						else if (event.keydown.sym == SDLK_c)
						{
							screen.fillRect(bgPixel);
							screen.updateRect();
						}
						break;
					case SDL_QUIT:
						done = true;
						break;
					default:
						break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
