/************************************************************
Copyright (C) 2004-2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj;

/**
* <code>SDLException</code> is the general class of exceptions 
* produced by sdl4gcj.
* @author  SAWAI, Masahiko
*/
public
class SDLException extends RuntimeException 
{
	
	/**
	* Returns error message from SDL system.
	* A wrapper method of <code>SDL_GetError()</code>.
	**/
	public static native String getError();

	/**
	* Constructs an <code>SDLException</code> with no 
	* detail message. 
	**/
	public SDLException() 
	{
		super(SDLException.getError());
	}

	/**
	* Constructs an <code>SDLException</code> with the 
	* specified detail message. 
	*
	* @param   message   the detail message.
	*/
	public SDLException(String message) {
		super(message);
	}

}
