/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.event;

public interface EventConstants
{
	// event types
	int SDL_NOEVENT = 0;           // Unused (do not remove) 
	int SDL_ACTIVEEVENT = 1;       // Application loses/gains visibility 
	int SDL_KEYDOWN = 2;           // Keys pressed 
	int SDL_KEYUP = 3;             // Keys released 
	int SDL_MOUSEMOTION = 4;       // Mouse moved 
	int SDL_MOUSEBUTTONDOWN = 5;   // Mouse button pressed 
	int SDL_MOUSEBUTTONUP = 6;     // Mouse button released 
	int SDL_JOYAXISMOTION = 7;     // Joystick axis motion 
	int SDL_JOYBALLMOTION = 8;     // Joystick trackball motion 
	int SDL_JOYHATMOTION = 9;      // Joystick hat position change 
	int SDL_JOYBUTTONDOWN = 10;    // Joystick button pressed 
	int SDL_JOYBUTTONUP = 11;      // Joystick button released 
	int SDL_QUIT = 12;             // User-requested quit 
	int SDL_SYSWMEVENT = 13;       // System specific event 
	int SDL_EVENT_RESERVEDA = 14;  // Reserved for future use.. 
	int SDL_EVENT_RESERVEDB = 15;  // Reserved for future use.. 
	int SDL_VIDEORESIZE = 16;      // User resized video mode 
	int SDL_VIDEOEXPOSE = 17;      // Screen needs to be redrawn 
	int SDL_EVENT_RESERVED2 = 18;  // Reserved for future use.. 
	int SDL_EVENT_RESERVED3 = 19;  // Reserved for future use.. 
	int SDL_EVENT_RESERVED4 = 20;  // Reserved for future use.. 
	int SDL_EVENT_RESERVED5 = 21;  // Reserved for future use.. 
	int SDL_EVENT_RESERVED6 = 22;  // Reserved for future use.. 
	int SDL_EVENT_RESERVED7 = 23;  // Reserved for future use.. 

    // Events USEREVENT through MAXEVENTS-1 are for your use
    int SDL_USEREVENT = 24;

	// This last event is only for bounding internal arrays
	// It is the number of bits in the event mask datatype -- Uint32
    int SDL_NUMEVENTS = 32;

	// press or release
	int SDL_RELEASED = 0;
	int SDL_PRESSED = 1;
}
