/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/event/EventManager.h"
#include "sdl4gcj/event/EventConstants.h"

#include "sdl4gcj/event/ActiveEvent.h"
#include "sdl4gcj/event/KeyboardEvent.h"
#include "sdl4gcj/event/MouseMotionEvent.h"
#include "sdl4gcj/event/MouseButtonEvent.h"
#include "sdl4gcj/event/JoyAxisEvent.h"
#include "sdl4gcj/event/JoyBallEvent.h"
#include "sdl4gcj/event/JoyHatEvent.h"
#include "sdl4gcj/event/JoyButtonEvent.h"
#include "sdl4gcj/event/QuitEvent.h"
#include "sdl4gcj/event/SysWMEvent.h"
#include "sdl4gcj/event/ResizeEvent.h"
#include "sdl4gcj/event/ExposeEvent.h"

#include <gcj/cni.h>
#include <stdlib.h>
#include <SDL.h>

using namespace ::sdl4gcj::event;


void
EventManager::setEvent (::gnu::gcj::RawData* rawEvent)
{
	SDL_Event* nativeEvent = (SDL_Event*)rawEvent;
	this->type = nativeEvent->type;

	switch (nativeEvent->type)
	{
	case EventConstants::SDL_ACTIVEEVENT:
		this->active->gain = nativeEvent->active.gain;
		this->active->state = nativeEvent->active.state;
		this->lastEvent = this->active;
		break;
	case EventConstants::SDL_KEYDOWN:
		this->keydown->which = (jshort)nativeEvent->key.which;
		this->keydown->state = (jshort)nativeEvent->key.state;
		this->keydown->scancode = (jshort)nativeEvent->key.keysym.scancode;
		this->keydown->sym = (jint)nativeEvent->key.keysym.sym;
		this->keydown->mod = (jint)nativeEvent->key.keysym.mod;
		this->keydown->unicode = (jchar)nativeEvent->key.keysym.unicode;
		this->lastEvent = this->keydown;
		break;
	case EventConstants::SDL_KEYUP:
		this->keyup->which = (jshort)nativeEvent->key.which;
		this->keyup->state = (jshort)nativeEvent->key.state;
		this->keyup->scancode = (jshort)nativeEvent->key.keysym.scancode;
		this->keyup->sym = (jint)nativeEvent->key.keysym.sym;
		this->keyup->mod = (jint)nativeEvent->key.keysym.mod;
		this->keyup->unicode = (jchar)nativeEvent->key.keysym.unicode;
		this->lastEvent = this->keyup;
		break;
	case EventConstants::SDL_MOUSEMOTION:
		this->motion->which = nativeEvent->motion.which; 
		this->motion->state = nativeEvent->motion.state;
		this->motion->x = nativeEvent->motion.x; 
		this->motion->y = nativeEvent->motion.y;
		this->motion->xrel = nativeEvent->motion.xrel; 
		this->motion->yrel = nativeEvent->motion.yrel;
		this->lastEvent = this->motion;
		break;
	case EventConstants::SDL_MOUSEBUTTONDOWN:
		this->buttondown->which = nativeEvent->button.which;
		this->buttondown->button = nativeEvent->button.button;
		this->buttondown->state = nativeEvent->button.state;
		this->buttondown->x = nativeEvent->button.x;
		this->buttondown->y = nativeEvent->button.y;
		this->lastEvent = this->buttondown;
		break;
	case EventConstants::SDL_MOUSEBUTTONUP:
		this->buttonup->which = nativeEvent->button.which;
		this->buttonup->button = nativeEvent->button.button;
		this->buttonup->state = nativeEvent->button.state;
		this->buttonup->x = nativeEvent->button.x;
		this->buttonup->y = nativeEvent->button.y;
		this->lastEvent = this->buttonup;
		break;
	case EventConstants::SDL_JOYAXISMOTION:
		this->jaxis->which = nativeEvent->jaxis.which;
		this->jaxis->axis = nativeEvent->jaxis.axis;
		this->jaxis->value = nativeEvent->jaxis.value;
		this->lastEvent = this->jaxis;
		break;
	case EventConstants::SDL_JOYBALLMOTION:
		this->jball->which = nativeEvent->jball.which;
		this->jball->ball = nativeEvent->jball.ball;
		this->jball->xrel = nativeEvent->jball.xrel;
		this->jball->yrel = nativeEvent->jball.yrel;
		this->lastEvent = this->jball;
		break;
	case EventConstants::SDL_JOYHATMOTION:
		this->jhat->which = nativeEvent->jhat.which;
		this->jhat->hat = nativeEvent->jhat.hat;
		this->jhat->value = nativeEvent->jhat.value;
		this->lastEvent = this->jhat;
		break;
	case EventConstants::SDL_JOYBUTTONDOWN:
		this->jbuttondown->which = nativeEvent->jbutton.which;
		this->jbuttondown->button = nativeEvent->jbutton.button;
		this->jbuttondown->state = nativeEvent->jbutton.state;
		this->lastEvent = this->jbuttondown;
		break;
	case EventConstants::SDL_JOYBUTTONUP:
		this->jbuttonup->which = nativeEvent->jbutton.which;
		this->jbuttonup->button = nativeEvent->jbutton.button;
		this->jbuttonup->state = nativeEvent->jbutton.state;
		this->lastEvent = this->jbuttonup;
		break;
	case EventConstants::SDL_QUIT:
		this->lastEvent = this->quit;
		break;
	case EventConstants::SDL_SYSWMEVENT:
		this->lastEvent = this->syswm;
		break;
	case EventConstants::SDL_VIDEORESIZE:
		this->resize->w = nativeEvent->resize.w;
		this->resize->h = nativeEvent->resize.h;
		this->lastEvent = this->resize;
		break;
	case EventConstants::SDL_VIDEOEXPOSE:
		this->lastEvent = this->expose;
		break;
	default:
		this->type = EventConstants::SDL_NOEVENT;
		this->lastEvent = NULL;
		break;
	}

}

void
EventManager::pushEvent (SDLEvent *event)
{
	JvInitClass(&sdl4gcj::event::EventManager::class$);
	SDL_Event nativeEvent;

	nativeEvent.type = event->type;
	switch (event->type)
	{
	case EventConstants::SDL_ACTIVEEVENT:
		{
			ActiveEvent* active = (ActiveEvent*)event;
			nativeEvent.active.gain = active->gain;
			nativeEvent.active.state = active->state;
		}
		break;
	case EventConstants::SDL_KEYDOWN:
	case EventConstants::SDL_KEYUP:
		{
			KeyboardEvent* key = (KeyboardEvent*)event;
			nativeEvent.key.which = key->which;
			nativeEvent.key.state = key->state;
			nativeEvent.key.keysym.scancode = key->scancode;
			nativeEvent.key.keysym.sym = (SDLKey)key->sym;
			nativeEvent.key.keysym.mod = (SDLMod)key->mod;
			nativeEvent.key.keysym.unicode = key->unicode;
		}
		break;
	case EventConstants::SDL_MOUSEMOTION:
		{
			MouseMotionEvent* motion = (MouseMotionEvent*)event;
			nativeEvent.motion.which = motion->which; 
			nativeEvent.motion.state = motion->state;
			nativeEvent.motion.x = motion->x; 
			nativeEvent.motion.y = motion->y;
			nativeEvent.motion.xrel = motion->xrel; 
			nativeEvent.motion.yrel = motion->yrel;
		}
		break;
	case EventConstants::SDL_MOUSEBUTTONDOWN:
	case EventConstants::SDL_MOUSEBUTTONUP:
		{
			MouseButtonEvent* button = (MouseButtonEvent*)event;
			nativeEvent.button.which = button->which;
			nativeEvent.button.button = button->button;
			nativeEvent.button.state = button->state;
			nativeEvent.button.x = button->x;
			nativeEvent.button.y = button->y;
		}
		break;
	case EventConstants::SDL_JOYAXISMOTION:
		{
			JoyAxisEvent* jaxis = (JoyAxisEvent*)event;
			nativeEvent.jaxis.which = jaxis->which;
			nativeEvent.jaxis.axis = jaxis->axis;
			nativeEvent.jaxis.value = jaxis->value;
		}
		break;
	case EventConstants::SDL_JOYBALLMOTION:
		{
			JoyBallEvent* jball = (JoyBallEvent*)event;
			nativeEvent.jball.which = jball->which;
			nativeEvent.jball.ball = jball->ball;
			nativeEvent.jball.xrel = jball->xrel;
			nativeEvent.jball.yrel = jball->yrel;
		}
		break;
	case EventConstants::SDL_JOYHATMOTION:
		{
			JoyHatEvent* jhat = (JoyHatEvent*)event;
			nativeEvent.jhat.which = jhat->which;
			nativeEvent.jhat.hat = jhat->hat;
			nativeEvent.jhat.value = jhat->value;
		}
		break;
	case EventConstants::SDL_JOYBUTTONDOWN:
	case EventConstants::SDL_JOYBUTTONUP:
		{
			JoyButtonEvent* jbutton = (JoyButtonEvent*)event;
			nativeEvent.jbutton.which = jbutton->which;
			nativeEvent.jbutton.button = jbutton->button;
			nativeEvent.jbutton.state = jbutton->state;
		}
		break;
	case EventConstants::SDL_QUIT:
		break;
	case EventConstants::SDL_SYSWMEVENT:
		break;
	case EventConstants::SDL_VIDEORESIZE:
		{
			ResizeEvent* resize = (ResizeEvent*)event;
			nativeEvent.resize.w = resize->w;
			nativeEvent.resize.h = resize->h;
		}
		break;
	case EventConstants::SDL_VIDEOEXPOSE:
		break;
	default:
		break;
	}

	SDL_PushEvent(&nativeEvent);
}

void 
EventManager::pumpEvents ()
{
	JvInitClass(&sdl4gcj::event::EventManager::class$);
	SDL_PumpEvents();
	return ;
}

jint
EventManager::pollEvent ()
{
	JvInitClass(&sdl4gcj::event::EventManager::class$);
	SDL_Event nativeEvent;

	if (SDL_PollEvent(&nativeEvent))
		this->setEvent((::gnu::gcj::RawData*)&nativeEvent);
	else
		this->type = EventConstants::SDL_NOEVENT;

	return this->type;
}

jint
EventManager::waitEvent ()
{
	JvInitClass(&sdl4gcj::event::EventManager::class$);
	SDL_Event nativeEvent;

	if (SDL_WaitEvent(&nativeEvent))
		this->setEvent((::gnu::gcj::RawData*)&nativeEvent);
	else
		this->type = EventConstants::SDL_NOEVENT;

	return this->type;
}

