/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/video/Palette.h"

#include "sdl4gcj/video/Color.h"
#include "sdl4gcj/SDLException.h"

#include <java/lang/IndexOutOfBoundsException.h>
#include <java/lang/OutOfMemoryError.h>

#include <gcj/cni.h>
#include <SDL.h>
#include <stdlib.h>


using namespace sdl4gcj::video;

// functions
static
inline
sdl4gcj::SDLException*
createIllegalPaletteException()
{
	return new sdl4gcj::SDLException(JvNewStringLatin1("Palette state is illegal."));
}

static
inline
java::lang::IndexOutOfBoundsException*
createIndexOutOfBoundsException()
{
	return new java::lang::IndexOutOfBoundsException(JvNewStringLatin1("Palette Index Out of Bounds"));
}

// instance methods
Color *
Palette::getColorAt (jint index)
{
	if (this->colors == NULL) throw createIllegalPaletteException();
	if (index < 0 || index >= this->size) throw createIndexOutOfBoundsException();
	SDL_Color* nativeColors = (SDL_Color*)this->colors;
	Color* color = new Color(nativeColors[index].r,
		nativeColors[index].g, nativeColors[index].b);
	return color;
}

void 
Palette::setColorAt (jint index, jint red, jint green, jint blue)
{
	if (this->colors == NULL) throw createIllegalPaletteException();
	if (index < 0 || index >= this->size) throw createIndexOutOfBoundsException();
	SDL_Color* nativeColors = (SDL_Color*)this->colors;
	nativeColors[index].r = red;
	nativeColors[index].g = green;
	nativeColors[index].b = blue;
	return ;
}

void 
Palette::initPalette (jint size)
{
	if (size != this->size)
	{
		this->freePalette();

		SDL_Color* nativeColors = (SDL_Color*)JvMalloc(sizeof(SDL_Color) * size);
		for (int i = size-1;i >= 0;i--)
		{
			nativeColors[i].r = 0;
			nativeColors[i].g = 0;
			nativeColors[i].b = 0;
		}
		this->colors = (::gnu::gcj::RawData*)nativeColors;
		this->size = size;
	}

	return ;
}

void 
Palette::freePalette ()
{
	if (this->colors != NULL) 
	{
		JvFree(this->colors);
		this->colors = NULL;
		this->size = 0;
	}
}
