/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.video;

public class PixelFormat
{
	protected PixelFormat()
	{
	}

	public PixelFormat(int depth, 
		int rmask, int gmask, int bmask, int amask)
	{
		initWithMask(depth, rmask, gmask, bmask, amask);
	}

	public native byte getBitsPerPixel();
	public native byte getBytesPerPixel();
	public native byte getRloss();
	public native byte getGloss();
	public native byte getBloss();
	public native byte getAloss();
	public native byte getRshift();
	public native byte getGshift();
	public native byte getBshift();
	public native byte getAshift();
	public native int getRmask();
	public native int getGmask();
	public native int getBmask();
	public native int getAmask();
	public native int getColorkey();
	public native int getAlpha();

	public native int mapRGB(int red, int green, int blue);
	public int mapRGB(Color color)
	{
		return mapRGB(color.r, color.g, color.b);
	}

	public native int mapRGBA(int red, int green, int blue, int alpha);
	public int mapRGBA(Color color)
	{
		return mapRGBA(color.r, color.g, color.b, color.a);
	}

	public native int[] getRGB(int pixel);
	public native Color getRGBColor(int pixel);

	public native int[] getRGBA(int pixel);
	public native Color getRGBAColor(int pixel);

	public native Palette getPalette();

	public String toString()
	{
		return super.toString() +
		"\ngetBitsPerPixel() : " + getBitsPerPixel() +
		"\ngetBytesPerPixel() : " + getBytesPerPixel() +
		"\ngetRloss() : " + getRloss() +
		"\ngetGloss() : " + getGloss() +
		"\ngetBloss() : " + getBloss() +
		"\ngetAloss() : " + getAloss() +
		"\ngetRshift() : " + getRshift() +
		"\ngetGshift() : " + getGshift() +
		"\ngetBshift() : " + getBshift() +
		"\ngetAshift() : " + getAshift() +
		"\ngetRmask() : " + Integer.toHexString(getRmask()) +
		"\ngetGmask() : " + Integer.toHexString(getGmask()) +
		"\ngetBmask() : " + Integer.toHexString(getBmask()) +
		"\ngetAmask() : " + Integer.toHexString(getAmask()) +
		"\ngetColorkey() : " + getColorkey() +
		"\ngetAlpha() : " + getAlpha();
	}

	protected void finalize() throws Throwable
	{
		this.freePixelFormat();
		super.finalize();
	}

	protected gnu.gcj.RawData implementation;

	private native void initWithMask(int depth,
		int rmask, int gmask, int bmask, int amask);
	private native void freePixelFormat();

	private boolean selfAllocated = false;
}
