import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.input.*;
import sdl4gcj.event.*;

public class MouseTest implements SDLConstants
{
	private Screen screen;
	private ImageFont font;
	private Mouse mouse;
	private int bgPixel;
	private StringBuffer message = new StringBuffer(256);

	private void drawMouseState()
	{
		screen.fillRect(bgPixel);

		int x = 10, y = 10;
		font.draw(screen, "MouseTest", x, y);

		y += font.getHeight();
		font.draw(screen, " Mouse#getButtonState(int)", x, y);

		y += font.getHeight();
		message.delete(0, message.length());
		message.append("  SDL_BUTTON_LEFT      : ");
		message.append(mouse.getButtonState(SDL_BUTTON_LEFT));
		font.draw(screen, message, x, y);

		y += font.getHeight();
		message.delete(0, message.length());
		message.append("  SDL_BUTTON_MIDDLE    : ");
		message.append(mouse.getButtonState(SDL_BUTTON_MIDDLE));
		font.draw(screen, message, x, y);

		y += font.getHeight();
		message.delete(0, message.length());
		message.append("  SDL_BUTTON_RIGHT     : ");
		message.append(mouse.getButtonState(SDL_BUTTON_RIGHT));
		font.draw(screen, message, x, y);

		y += font.getHeight();
		message.delete(0, message.length());
		message.append("  SDL_BUTTON_WHEELUP   : ");
		message.append(mouse.getButtonState(SDL_BUTTON_WHEELUP));
		font.draw(screen, message, x, y);

		y += font.getHeight();
		message.delete(0, message.length());
		message.append("  SDL_BUTTON_WHEELDOWN : ");
		message.append(mouse.getButtonState(SDL_BUTTON_WHEELDOWN));
		font.draw(screen, message, x, y);

		y += font.getHeight();
		message.delete(0, message.length());
		message.append(" Mouse#getX() : ");
		message.append(mouse.getX());
		font.draw(screen, message, x, y);

		y += font.getHeight();
		message.delete(0, message.length());
		message.append(" Mouse#getY() : ");
		message.append(mouse.getY());
		font.draw(screen, message, x, y);

//		y += font.getHeight();
//		message.delete(0, message.length());
//		message.append(" Mouse#getRelativeX() : ");
//		message.append(mouse.getRelativeX());
//		font.draw(screen, message, x, y);

//		y += font.getHeight();
//		message.delete(0, message.length());
//		message.append(" Mouse#getRelativeY() : ");
//		message.append(mouse.getRelativeY());
//		font.draw(screen, message, x, y);

		screen.flip();
	}
	
	public void initialize()
	{
		SDLSystem.init(SDL_INIT_VIDEO);
		screen = Screen.setVideoMode(640, 480, 8, SDL_SWSURFACE|SDL_ANYFORMAT|SDL_DOUBLEBUF);

		bgPixel = screen.mapRGB(Color.BLACK);
		font = new ImageFont();
		mouse = Mouse.getMouse();
	}

	public void mainLoop()
	{
		try
		{
			this.drawMouseState();

			EventManager event = new EventManager();
			boolean done = false;
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
					case SDL_KEYDOWN :
						if (event.keydown.sym == SDLK_q ||
							event.keydown.sym == SDLK_ESCAPE) done = true;
						break;
					case SDL_MOUSEBUTTONDOWN :
					case SDL_MOUSEBUTTONUP :
					case SDL_MOUSEMOTION :
						this.drawMouseState();
						break;
					case SDL_QUIT :
						done = true;
						break;
					default:
						break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			SDLSystem.quit();
		}
	}

	public static void main(String[] args)
	{
		MouseTest mouseTest = new MouseTest();
		mouseTest.initialize();
		mouseTest.mainLoop();
	}
}
