
#include <stdio.h>
#include <string.h>

#include "SDL_archive.h"
#include "SDL.h"


void PrintIndent(int nest)
{
	int i;
	
	for (i = 0; i < nest; i++) {
		if (i < nest - 1) {
			printf(" ");
		} else {
			printf("+");
		}
	}
}


int ListDirectory(SDL_Archive *arc, int nest, int isSize)
{
	int i;
	int result;
	
	for (i = 0; i < Archive_GetChildDirNum(arc); i++) {
		printf("d:");
		PrintIndent(nest + 1);
		printf(
			"%s(%s)\n",
			Archive_GetChildDirName(arc, i),
			Archive_GetCurrentDirPath(arc));
		result = Archive_GoDownDir(
			arc, Archive_GetChildDirName(arc, i));
		if (result != ARCHIVE_SUCCESS) {
			printf(
				"!ERROR: %s ... Archive_GoDownDir is failed\n",
				Archive_GetChildDirName(arc, i));
		}
		if (result == ARCHIVE_SUCCESS) {
			ListDirectory(arc, nest + 1, isSize);
			Archive_GoUpDir(arc);
		}
	}
	for (i = 0; i < Archive_GetFileNum(arc); i++) {
		printf("f:");
		PrintIndent(nest + 1);
		if (isSize) {
			result = Archive_Open(arc, Archive_GetFileName(arc, i));
			if (result == ARCHIVE_SUCCESS) {
				printf(
					"%s(%s) %d byte\n",
					Archive_GetFileName(arc, i),
					Archive_GetCurrentDirPath(arc),
					Archive_Size(arc));
				Archive_Close(arc);
			} else {
				printf(
					"%s(%s) file open error\n",
					Archive_GetFileName(arc, i),
					Archive_GetCurrentDirPath(arc));
			}
		} else {
			printf(
				"%s(%s)\n",
				Archive_GetFileName(arc, i),
				Archive_GetCurrentDirPath(arc));
		}
	}
	
	return 0;
}


int main(int argc, char *argv[])
{
	ArchiverList *archiverList;
	SDL_Archive *arc;
	int i;
	int openArgvNum;
	int isSize;
	int isGZFilter;
	
	if (argc == 1) {
		printf("Usage: %s [-size] [-gzfilter] archive\n", argv[0]);
		return 0;
	}
	
	SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO);
	
	isSize = SDL_FALSE;
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			if (strcmp(argv[i], "-size") == 0) {
				isSize = SDL_TRUE;
			} else if (strcmp(argv[i], "-gzfilter") == 0) {
				isGZFilter = SDL_TRUE;
			} else {
				printf("Option(%s) is unknown", argv[i]);
				return -1;
			}
		} else {
			/* archive name */
			break;
		}
	}
	
	if (i == argc) {
		printf("Usage: %s [-size] archive\n", argv[0]);
		return 0;
	}
	openArgvNum = i;
	
	archiverList = ArchiverList_Create();
	if (archiverList == NULL) {
		printf("archiver list allocate error\n");
		return -1;
	}
	ArchiverList_AddArchiver(
		archiverList,
		Archive_IsTar,
		Archive_FromTar);
	ArchiverList_AddArchiver(
		archiverList,
		Archive_IsDirectory,
		Archive_FromDirectory);
	ArchiverList_AddArchiver(
		archiverList,
		Archive_IsPKZip,
		Archive_FromPKZip);
	
	if (isGZFilter) {
		arc = Archive_FromArchiverList(archiverList, argv[openArgvNum]);
	} else {
		arc = Archive_FromGZFilter(archiverList, argv[openArgvNum]);
	}
	ArchiverList_Free(archiverList);
	if (arc == NULL) {
		printf("\"%s\" not found\n", argv[openArgvNum]);
		return -1;
	}
	printf("\"%s\" loaded.\n", argv[openArgvNum]);
	
	printf("d:");
	PrintIndent(0);
	printf(
		"%s(%s)\n",
		Archive_GetCurrentDirName(arc),
		Archive_GetCurrentDirPath(arc));
	ListDirectory(arc, 0, isSize);
	
	Archive_Finish(arc);
	
	SDL_Quit();
	
	return 0;
}
